const {getFirstSymbolForRetpathQuery} = require('../../common/getFirstSymbolForRetpathQuery');
const {postBindCard} = require('../utils');

module.exports = async (req, res, next) => {
    const {cardId, status, origin} = req.query;
    const {locals: {validRetpath: retpath = ''} = {}} = res;

    if (status === 'error') {
        return origin && retpath
            ? res.redirect(`${retpath}${getFirstSymbolForRetpathQuery(retpath)}status=${status}`)
            : next();
    }

    postBindCard(req, res, res.locals.track_id, cardId, retpath, origin).then(
        ({redirectUrl = '', retpath = '', state = ''} = {}) => {
            let modRetpath = null;

            if (retpath) {
                switch (state) {
                    case 'error': {
                        modRetpath = `${retpath}${getFirstSymbolForRetpathQuery(retpath)}status=error`;
                        break;
                    }
                    case 'bind': {
                        modRetpath = `${retpath}${getFirstSymbolForRetpathQuery(retpath)}status=success`;
                        break;
                    }
                    case 'challenge': {
                        modRetpath = null;
                        break;
                    }
                }
            }

            const redirectTo = modRetpath || redirectUrl;

            return redirectTo ? res.redirect(redirectTo) : next();
        }
    );
};
