const url = require('url');
const PLog = require('plog');
const config = require('../../../configs/current');
const isFamilyEnable = require('../../common/isFamilyEnable');
const {getFamilyOriginOptions} = require('../../common/getFamilyOriginOptions');
const CONSTS = require('../const');
const {fetchFamilyInfo, fetchInviteInfo} = require('../utils');

const getPage = (entry, countryId) =>
    isFamilyEnable(countryId) ? CONSTS.ENTRY_PAGES_MAP[entry] || CONSTS.ENTRY_PAGES_MAP.main : 'main.stub';

const putFamilyInStoreCommon = async (req, res, entry, {withAccount = false, withBBUsers = true} = {}) => {
    const familyInfo = await fetchFamilyInfo(req, res, {withUid: true, withAccount, withBBUsers});
    const {
        members = [],
        kids = [],
        familyCapacity,
        kiddishCapacity,
        invites = [],
        pay = {},
        familyId,
        hasFamilySubscription,
        account = null
    } = familyInfo;

    if (withAccount && account) {
        const locals = res.locals;
        const tld = req._controller.getTld();
        const yandexuid = res._yandexuid && res._yandexuid.replace(/[^0-9]/g, '');
        const handlers = [req._controller.getUatraits()];
        const links = config.links[tld] || config.links.ru || {};
        const defaultAccount = (locals.accounts && locals.accounts.defaultAccount) || {};
        const plusInfo = defaultAccount.plus || {};
        const retpath = (req.query && (req.query.url || req.query.retpath)) || null;
        const embeddedauth = config.paths.embeddedauth && config.paths.embeddedauth.replace('%tld%', tld);
        const experiments = Object.assign(
            {},
            {
                flags: [],
                flagsString: '',
                boxes: '',
                encodedBoxes: ''
            },
            res.locals.experiments
        );

        handlers.push(req.api.validateRetpath({retpath}));

        locals.reactPage = 'profile.passportv2';

        const {paths = {}, version} = config;
        const {static: staticPath} = paths;
        const {userType = {}} = locals;
        const {metricsUserType} = userType;

        locals.store = {
            dashboard: {
                plus: Object.assign(
                    {},
                    {
                        country: locals.country,
                        allowed: locals.showPlus,
                        enabled: false,
                        enabledTime: 0,
                        trialUsedTime: 0,
                        subscriptionStoppedTime: 0,
                        subscriptionExpireTime: 0,
                        nextChargeTime: 0,
                        expireDate: ''
                    },
                    plusInfo
                ),
                errors: {},
                messages: {},
                isLoading: {},
                experiments: {}
            },
            settings: {
                isNewLayout: !locals.isLite,
                location: req.path,
                plusHost: config.paths && config.paths.plus && `//${config.paths.plus.replace('%tld%', tld)}`,
                host: url.format({
                    protocol: req.headers['x-real-scheme'],
                    hostname: req.hostname
                }),
                avatar: config.paths.avatar || {},
                embeddedauth,
                links,
                help: config.paths.help || {},
                tld,
                language: locals.language,
                ua: {},
                env: {
                    type: process.env.NODE_ENV,
                    name: process.env.INTRANET
                },
                billingUpdateStatus: url.format({
                    protocol: req.headers['x-real-scheme'],
                    hostname: req.hostname,
                    pathname: config.paths.billingUpdateStatusPath
                }),
                staticPath,
                accountsUrl: config.paths.accountsUrl,
                version,
                metricsUserType
            },
            common: {
                v2: !locals.isLite, // PASSP-32231
                origin: (req.query || {}).origin,
                process_uuid: res.locals.process_uuid,
                canChangePassword: account.can_change_password,
                edit: locals.edit || '',
                showRegPopup: false,
                hasComponentsForNav: true,
                actionForRepeat: null,
                uid: account.uid,
                yandexuid,
                // при загрузке срабатывает POP event и уменьшает историю на 1, а так тут должен быть 0
                historyOnPassport: 1,
                track_id: locals.track_id,
                retpath: null,
                backpath: null,
                defaultPage: url.format({
                    pathname: '/profile',
                    query: req.query
                }),
                isPDD: account.domain !== undefined,
                isWSUser: locals.isWSUser,
                dev: config.dev,
                experiments,
                isYandexoid: locals.isYandexoid,
                isYandex: locals.isYandex,
                locationCountryId: locals.countryId,
                isFamilyEnable: isFamilyEnable(locals.countryId),
                isSupportCenterEnable:
                    ((experiments.flags && experiments.flags.includes('support-window-enable')) ||
                        locals.isYandex ||
                        locals.isYandexoid) &&
                    locals.ua &&
                    locals.ua.BrowserName !== 'MSIE'
            },
            social: {
                brokerPath: config.paths.broker
            },
            person: Object.assign({}, account.person || {}, {
                avatarId: (account.display_name && account.display_name.default_avatar) || '',
                displayName: defaultAccount.displayName || '',
                publicDisplayName: defaultAccount.publicDisplayName || ''
            }),
            phones: {
                restore: [],
                other: [],
                completeSms2fa: req.query.completeSms2fa && req.query.completeSms2fa === '1'
            },
            billing: {},
            form: {},
            metrics: {
                header: 'Webview семьи',
                experiments: experiments.encodedBoxes || ''
            },
            monitoring: {
                page: 'passport.v2'
            }
        };

        if (account.phones) {
            Object.keys(account.phones).forEach(function(code) {
                const phone = account.phones[code];

                if (phone.bound) {
                    locals.store.phones[phone.secured ? 'restore' : 'other'].push({
                        id: phone.id,
                        number: phone.number.masked_international,
                        isDefault: phone.is_default,
                        isAlias: phone.is_alias
                    });
                }
            });
        }

        await Promise.all(handlers)
            .then((response) => {
                const [uatraits = {}, validatedRetpath = {}] = response;

                locals.store.settings.ua = uatraits;
                locals.store.settings.isPhone = (uatraits.isMobile || uatraits.isTouch) && !uatraits.isTablet;
                locals.store.settings.isTouch = uatraits.isMobile || uatraits.isTouch;

                if (validatedRetpath.body && validatedRetpath.body.retpath) {
                    locals.store.common.retpath = validatedRetpath.body.retpath;
                }
            })
            .catch((err) => {
                PLog.warn()
                    .logId(req.logID)
                    .type('profile.passport.v2')
                    .write(err);
            })
            .finally(() => {
                delete locals.account;
                delete locals.accounts;
            });
    }

    const store = res.locals.store || {};
    const {settings} = store;
    const isMobile = settings.ua && settings.ua.isMobile && !settings.ua.isTablet;

    res.locals.store.family = {
        hasFamilySubscription: false,
        currentSlot: {isEmpty: true},
        currentSlotUserIndex: 0,
        inviteTarget: isMobile ? 'link' : 'smsOrMail',
        familyId: null,
        hasFamily: false,
        loading: false,
        isOneEmptyCard: true,
        error: null,
        inviteId: null,
        inviteContact: null,
        inviteConfirmed: false,
        isAdminAccess: false,
        familyCapacity: 0,
        kiddishCapacity: 0,
        slots: [],
        memberSlots: [],
        membersAndEmptySlots: [],
        inviteSlots: [],
        kiddishSlots: [],
        isFamilyOfferLoading: false,
        pageInfo: {page: getPage(entry, res.locals.countryId)},
        notification: {
            isVisible: false,
            text: '',
            iconType: '',
            theme: 'default'
        }
    };

    // eslint-disable-next-line no-unused-vars
    const memberSlots = members.map(({uid, ...member}) => ({...member, isUser: true}));
    const kiddishSlots = kids.map((kid) => ({...kid, isKiddish: true}));
    const membersWithoutAdmin = memberSlots.filter((slot) => !slot.isAdmin);
    const inviteSlots = invites.map((invite) => ({...invite, isInvite: true}));
    const slots = memberSlots.concat(inviteSlots);
    const yourSlot = memberSlots.find((member) => member.isYou);
    const adminSlot = memberSlots.find((member) => member.isAdmin);
    const isAdminAccess = !familyId || Boolean(adminSlot.isYou);

    res.locals.store.family = {
        ...res.locals.store.family,
        hasFamilySubscription,
        memberSlots,
        membersAndEmptySlots: memberSlots.concat({isEmpty: true}),
        inviteSlots,
        slots: isAdminAccess && slots.length < familyCapacity ? slots.concat({isEmpty: true}) : slots,
        kiddishSlots: kiddishSlots.length < kiddishCapacity ? kiddishSlots.concat({isEmpty: true}) : kiddishSlots,
        yourSlot,
        currentSlot: {isEmpty: true},
        hasMembers: Boolean(membersWithoutAdmin.length),
        currentSlotLimitInfo: {},
        currentSlotUserIndex: 0,
        familyId,
        isAdminAccess,
        hasFamily: Boolean(familyId),
        familyCapacity,
        kiddishCapacity,
        slotsCountByGroup: {
            member: memberSlots.length,
            kiddish: kiddishSlots.length
        },
        membersWithoutAdminSlots: membersWithoutAdmin,
        membersWithoutAdminAndEmptySlots: membersWithoutAdmin.concat({isEmpty: true}),
        adminSlot
    };

    const {cardInfo: {bound} = {}} = pay;

    if (bound) {
        const usersInfo = (pay.usersInfo || []).map((userInfo) => ({
            ...userInfo,
            allowAllServices: Boolean(userInfo.allowAllServices),
            allowedServices: userInfo.allowAllServices ? [] : userInfo.allowedServices,
            isCardActualyEnabled:
                userInfo.isEnabled &&
                (userInfo.allowAllServices ||
                    CONSTS.PAY_SERVICES.some((service) => userInfo.allowedServices.includes(service)))
        }));

        res.locals.store.family = {
            ...res.locals.store.family,
            yourSlotLimitInfo: yourSlot && usersInfo.find((userInfo) => userInfo.placeId === yourSlot.placeId),
            pay: {
                ...pay,
                usersInfoByPlaceId: usersInfo.reduce((acc, userInfo) => {
                    acc[userInfo.placeId] = userInfo;

                    return acc;
                }, {})
            },
            payLimitsForm: usersInfo,
            payFormLimitCurrency: pay.cardInfo && pay.cardInfo.currency
        };

        if (!yourSlot) {
            PLog.warn()
                .logId(req.logID)
                .type('profile.passport.v2', 'putFamilyInStoreCommon')
                .write('yourSlot is undefined');
        }
    }

    return familyInfo;
};

module.exports = (entry, options = {}) => async (req, res, next) => {
    const {withAccount = false, isAm = false, withBBUsers = true} = options;
    const origin = req.query && req.query.origin;
    const familyInfo = await putFamilyInStoreCommon(req, res, entry, {withAccount, withBBUsers});
    const {store = {}} = res.locals;
    const {isTouch = false} = store.settings;
    const originOptions = getFamilyOriginOptions(origin) || null;

    if (originOptions) {
        const {
            origin,
            withPayOrigin,
            isWebview,
            isLite,
            hideServices,
            hideFamilyInvite,
            hideWebviewHeader,
            hideKiddish,
            hideLimitsPageBackButton,
            hideSupport,
            hidePayCardsPageBackButton,
            hideInvitePageBackButton,
            hideMembersBackButton,
            hideInviteCancelBackButton,
            hideFormLimitsUsers,
            limitsPageBottomPadding,
            notRedirectWithoutRetpath,
            notRedirectAfterInvite,
            isCrossBackButton
        } = originOptions;

        store.settings.isLite = isLite;
        store.settings.isNewLayout = !isLite;

        store.family = {
            ...store.family,
            isWebview,
            origin,
            withPayOrigin,
            hideServices,
            hideFamilyInvite,
            hideWebviewHeader,
            hideKiddish,
            hideLimitsPageBackButton,
            hideSupport,
            hidePayCardsPageBackButton,
            hideInvitePageBackButton,
            hideMembersBackButton,
            hideInviteCancelBackButton,
            hideFormLimitsUsers,
            limitsPageBottomPadding,
            notRedirectWithoutRetpath,
            notRedirectAfterInvite,
            isCrossBackButton
        };
    }

    if (isAm) {
        store.family.withPayOrigin = true;
    }

    if (['limits', 'limitsMember'].includes(entry)) {
        const {family = {}} = store;
        const {members = []} = familyInfo;
        const {yourSlot = {}, membersWithoutAdminSlots = [], pay = {}} = family;
        const {cardInfo: {bound} = {}} = pay;
        const {isAbleToUsePay} = yourSlot;
        const showLimitsPageStub = originOptions && originOptions.showLimitsPageStub;
        const preFilledLimitValue = req.query && Number(req.query.member_add_limit);
        const preFilledLimitMode = req.query && String(req.query.member_limit_mode);
        const uidFromParams = req.query && Number(req.query.member_uid);
        const hasLimitPreFilled = preFilledLimitValue && preFilledLimitMode && uidFromParams;

        const needRedirectMemberToFamilyPush =
            entry === 'limitsMember' && isAm && (!isAbleToUsePay || !bound || !pay.usersInfo);
        const needRedirectAdminToFamilyPush =
            entry === 'limits' && isAm && (!isAbleToUsePay || !bound || !membersWithoutAdminSlots.length);

        if (needRedirectMemberToFamilyPush || needRedirectAdminToFamilyPush) {
            return req._controller.redirectToLocalUrl({
                pathname: '/am/push/family',
                query: req.query
            });
        }

        if (showLimitsPageStub) {
            let errorKey = null;

            if (!pay.usersInfo || !bound) {
                errorKey = 'hasNotCard';
            }
            if (!membersWithoutAdminSlots.length) {
                errorKey = 'hasNotMembers';
            }

            if (errorKey) {
                store.family.hasLimitsError = true;
                store.family.isLimitsPage = true;
                store.family.limitsError = CONSTS.LIMIT_PAGE_ERRORS_WITH_STUB[errorKey];

                return next();
            }
        }

        if (!pay.usersInfo || !membersWithoutAdminSlots.length) {
            return next('route');
        }

        let [currentMemberSlot, currentSlotUserIndex, hasPrefilledMember] = [null, 1, false];

        members.forEach((member, i) => {
            if (member.uid === uidFromParams) {
                currentMemberSlot = {...member, isUser: true};
                currentSlotUserIndex = i;
                hasPrefilledMember = true;
            }
        });

        const defaultAdminAccess = entry === 'limits';
        const yourSlotLimitInfo = pay.usersInfo.find((userInfo) => userInfo.placeId === yourSlot.placeId);
        const currentSlot = defaultAdminAccess ? currentMemberSlot || membersWithoutAdminSlots[0] : yourSlot;
        const currentSlotLimitInfo = pay.usersInfo.find((userInfo) => userInfo.placeId === currentSlot.placeId);

        let updatedCurrentSlotLimitInfo = null;

        if (hasLimitPreFilled) {
            const {limit: {value: oldValue} = {}} = currentSlotLimitInfo;
            const newValue =
                preFilledLimitMode === 'NOLIMIT'
                    ? oldValue
                    : Math.min(oldValue + preFilledLimitValue, CONSTS.MAX_LIMIT);

            updatedCurrentSlotLimitInfo = {
                ...currentSlotLimitInfo,
                limit: {...currentSlotLimitInfo.limit, value: newValue, limitMode: preFilledLimitMode}
            };
        }

        store.family = {
            ...store.family,
            currentSlot,
            currentSlotLimitInfo,
            currentSlotUserIndex,
            currentSlotFormLimitInfo: updatedCurrentSlotLimitInfo || currentSlotLimitInfo,
            isAdminAccess: defaultAdminAccess,
            isLimitsPage: true,
            yourSlotLimitInfo,
            hasLimitPreFilled,
            preFilledLimitValue,
            preFilledLimitMode,
            hasPrefilledMember
        };
    }

    if (entry === 'after3ds') {
        store.family.is3dsSuccess = req.query.status !== 'error';
        store.family.cardId3ds = req.query.cardId;
        store.family.pageInfo = isTouch ? {page: 'pay.after3ds', modal: null} : {page: 'main', modal: 'pay.after3ds'};
    }

    if (entry === 'invite') {
        store.family.isAdminAccess = true;
        store.family.isInvitePage = true;
        store.family.pageInfo = isFamilyEnable(res.locals.countryId)
            ? isTouch
                ? {page: 'invite.redesign', modal: null}
                : {page: 'main', modal: 'invite.redesign'}
            : {page: 'main.stub', modal: null};
    }

    if (entry === 'invite.confirm') {
        return fetchInviteInfo(req, res, req.params.inviteId)
            .then(({admin}) => {
                store.family = {
                    ...store.family,
                    pageInfo: {page: getPage('inviteAccept', res.locals.countryId)},
                    isInvitePage: true,
                    inviteId: req.params.inviteId,
                    currentSlot: admin
                };
                next();
            })
            .catch((errors = []) => {
                store.family = {
                    ...store.family,
                    isInvitePage: true,
                    error: errors[0],
                    pageInfo: {page: 'error'}
                };
                next();
            });
    }

    if (entry === 'inviteWelcome') {
        const {family: {isAdminAccess} = {}} = store;

        store.family.pageInfo = isAdminAccess
            ? {page: getPage('main', res.locals.countryId)}
            : {page: getPage(entry, res.locals.countryId)};
    }

    if (entry === 'payCards') {
        const {phones: {restore = []} = {}} = store;

        if (!restore.length) {
            store.family.isPayCardsPage = true;
            store.family.pageInfo = isTouch ? {page: 'add.phone', modal: null} : {page: 'main', modal: 'add.phone'};

            return next();
        }

        store.family.isPayCardsPage = true;
        store.family.pageInfo = isTouch ? {page: 'pay.cards', modal: null} : {page: 'main', modal: 'pay.cards'};
    }

    if (['deleteMember', 'leaveMember'].includes(entry)) {
        const {family = {}} = store;
        const {members = []} = familyInfo;
        const {isAdminAccess} = family;
        const uidFromParams = req.query && Number(req.query.member_uid);
        const {blackbox: {default_uid: defaultUid} = {}} = req;

        if (entry === 'leaveMember' && Number(defaultUid) !== uidFromParams) {
            return next('route');
        }

        let currentMemberSlot = null;

        members.forEach((member) => {
            if (member.uid === uidFromParams) {
                currentMemberSlot = {...member, isUser: true};
            }
        });

        if (!currentMemberSlot) {
            return next('route');
        }

        const curPage =
            entry === 'leaveMember' || (isAdminAccess && currentMemberSlot.isAdmin) ? 'member.leave' : 'member.exclude';

        const pageInfo = isTouch ? {page: curPage, modal: null} : {page: 'main', modal: curPage};

        store.family = {
            ...store.family,
            currentSlot: currentMemberSlot,
            isMemberPage: true,
            pageInfo
        };
    }

    if (entry === 'inviteSlot') {
        const {family: {inviteSlots = {}} = {}} = store;
        const inviteIdFromParams = req.query && req.query.invite_id;

        const currentInviteSlot = inviteSlots.find((slot) => slot.inviteId === inviteIdFromParams);

        if (!currentInviteSlot) {
            return next('route');
        }

        store.family = {
            ...store.family,
            currentSlot: currentInviteSlot,
            isMemberPage: true,
            isInviteCancelPage: true,
            pageInfo: {page: 'slot.info', modal: null}
        };
    }

    next();
};
