var url = require('url');

exports.routes = {};

exports.route = function(app) {
    var routes = this.routes;

    app.get(
        '/passport/?',
        function(req, res, next) {
            if (req.nquery && req.nquery.mode === 'genauthtoken') {
                next();
            } else {
                next('route');
            }
        },
        routes.main
    );
};

exports.routes.main = [genAuthToken];

function genAuthToken(req, res) {
    var data = {
        token: 'stub'
    };

    data['url'] = url.format({
        protocol: req.headers['x-real-scheme'],
        host: req.hostname,
        pathname: 'passport',
        query: {
            mode: 'tauth',
            token: data.token,
            retpath: (req.nquery && req.nquery.retpath) || ''
        }
    });
    res.set('content-type', 'text/xml; charset=utf-8');
    res.render('genauthtoken.ru.js', data);
}

exports.genAuthToken = genAuthToken;
