const validateCSRF = require('../common/validateCSRF');
const timezones = require('../../lib/geo/timezones.json');

function getTimezones(req, res) {
    let lang = req.body.lang;

    if (lang) {
        if (lang === 'fr') {
            lang = 'en';
        }

        return res.json({timezones: timezones[lang] || []});
    }

    return res.json({timezones});
}

module.exports = [validateCSRF, getTimezones];
