var apiSetup = require('./common/apiSetup');
var url = require('url');
var locs = require('../loc/auth.json');
var _ = require('lodash');
var when = require('when');
var PLog = require('plog');

exports.routes = {};

exports.route = function(app) {
    var routes = this.routes;

    app.all('/info/pdd-deny/?', langSetup, routes.pddInfo);

    app.all('/info/openid-closed/?', apiSetup, langSetup, routes.openIdInfo);
};

exports.routes.pddInfo = function(req, res) {
    /* jshint unused:false */

    var retpath = (req.body && req.body.retpath) || (req.nquery && req.nquery.retpath);
    var lang = res.locals.language;
    var loc = locs[lang];

    var REGIONAL_DOMAIN = ['ua', 'by', 'kz'];

    var controller = req._controller;
    var domain = controller.getTld();

    var auth = {
        protocol: req.headers['x-real-scheme'],
        hostname: req.hostname,
        pathname: 'auth',
        query: {
            mode: 'add-user'
        }
    };

    var registration = {
        protocol: req.headers['x-real-scheme'],
        hostname: REGIONAL_DOMAIN.indexOf(domain) > -1 ? 'passport.yandex.ru' : req.hostname,
        pathname: 'registration',
        query: {}
    };

    var data;

    if (retpath) {
        auth.query.retpath = _.escape(retpath);
        registration.query.retpath = _.escape(retpath);
    }

    data = {
        'head-title': loc['Frontend']['passport'],
        'servise-title': loc['Frontend']['passport'],
        title: loc['Frontend']['pdd_permission_denied_title'],
        domain,
        indent: true,
        messages: [
            loc['Frontend']['pdd_permission_denied_descr']
                .replace('%auth-url%', url.format(auth))
                .replace('%reg-url%', url.format(registration))
        ]
    };

    return res.render(`auth.message.${lang}.js`, data);
};

exports.routes.openIdInfo = function(req, res) {
    /* jshint unused:false */
    var data;
    var controller = req._controller;
    var domain = controller.getTld();
    var lang = res.locals.language;

    data = {
        title: 'Яндекс больше не поддерживает OpenID',
        domain,
        indent: true,
        /* eslint-disable max-len */
        messages: [
            '<p>К сожалению, на этот сайт больше нельзя зайти с помощью аккаунта на Яндексе, потому что он использует устаревшую технологию OpenID и не поддерживает новую — API Яндекс.Паспорта.</p>' +
                '<p>Вы можете зайти на сайт другим способом: <ul><li>зарегистрировать новый аккаунт;</li><li>авторизоваться с помощью другого сервиса, например, социальной сети.</li></ul></p>' +
                '<p>Если вы хотите использовать свою учётную запись Яндекса на этом сайте, пожалуйста, попробуйте восстановить пароль или обратитесь в службу поддержки сайта.</p>' +
                '<p><em>Если вы вебмастер, то можете настроить на своём сайте социальную авторизацию для пользователей Яндекса. Чтобы сделать это, пожалуйста, подключите API Яндекс.Паспорта.' +
                ' <a href="https://tech.yandex.ru/passport/doc/dg/concepts/openid-migrate-docpage/">Подробнее об установке API</a></em></p>'
        ]
        /* eslint-enable max-len */
    };

    var statBoxData = {
        ignoreMissedTrack: true,
        mode: 'openid_closed',
        action: 'opened',
        yandexuid: req.cookies['yandexuid'],
        ip: req.headers['x-real-ip'],
        user_agent: req.headers['user-agent'],
        experiments_flags: res.locals.experiments && res.locals.experiments.flagsString,
        experiment_boxes: res.locals.experiments && res.locals.experiments.boxes
    };

    when.all([controller.getAuth().sessionID()])
        .then(function() {
            statBoxData.uid = controller.getAuth().getUid();
            req.api.statboxLogger(statBoxData).catch(function(err) {
                PLog.warn()
                    .logId(req.logID)
                    .type('openid closed statbox')
                    .write(err);
            });
        })
        .catch(function(err) {
            PLog.warn()
                .logId(req.logID)
                .type('openid closed getAuth')
                .write(err);
        });

    return res.render(`auth.message.${lang}.js`, data);
};

function langSetup(req, res, next) {
    var controller = req._controller;

    controller
        .getLanguage()
        .then(function(lang) {
            res.locals.language = lang;
        })
        .catch(function(err) {
            res.locals.language = 'ru';

            PLog.warn()
                .logId(req.logID)
                .type('oauth pddinfo')
                .write(err);
        })
        .done(function() {
            return next();
        });
}
