var langSetup = require('./common/langSetup');

module.exports.getLangdetectDescription = [
    function(req, res, next) {
        if (res.locals.isYandex) {
            return next();
        }

        return next('route');
    },
    langSetup,
    async function(req, res) {
        let data = {
            title: 'Описание langdetect',
            current: {
                language: res.locals.language
            },
            config: {}
        };
        const self = req._controller;

        let passLang = '';

        let defaultUser = null;

        const sessionInfo = self._request.blackbox;
        const users = sessionInfo && sessionInfo.users;
        const defaultUid = sessionInfo && sessionInfo.default_uid;

        let i = users && users.length;

        if (users) {
            while (i--) {
                if (users[i].id === defaultUid) {
                    defaultUser = users[i];
                    break;
                }
            }

            if (defaultUser) {
                passLang = defaultUser.attributes && defaultUser.attributes['34'];
            }
        }

        data = {
            ...data,
            config: {
                headers: self.getHeaders(),
                ip: self.getIp(),
                cookie: self.getCookie('my') || '',
                passLang
            }
        };

        const isYandexMusic = Boolean(self.getHeader('x-yandex-music-client'));

        let explicitLanguage = self.explicitLanguage || self.getHeader('x-yandex-required-language');

        if (isYandexMusic) {
            explicitLanguage = self.getHeader('accept-language');
        }

        // eslint-disable-next-line no-unused-vars
        const {langlist, ...langdetect} = self._request._langdetect || {};

        data = {
            ...data,
            title: 'Описание langdetect',
            current: {
                language: res.locals.language
            },
            config: {
                ...data.config,
                isYandexMusic,
                explicitLanguage,
                langdetect,
                track_id: self.getRequestParam('track_id'),
                language: self.getRequestParam('language'),
                country: self.getRequestParam('country'),
                logID: self.getLogId()
            }
        };

        return res.json(data);
    }
];
