const url = require('url');
const express = require('express');
const router = express.Router();
const PLog = require('plog');
const config = require('../configs/current');
const langSetup = require('./common/langSetup');
const apiSetup = require('./common/apiSetup');
const getUatraitsData = require('./common/getUatraitsData');
const rumCounterSetup = require('./common/rumCounterSetup');
const getMetrics = require('./common/getMetrics');
const checkAuth = require('./common/checkAuth');
const multiAuthAccountsSetup = require('./common/multiAuthAccountsSetup').getAccounts;
const removePhonishes = require('./profile.social').removePhonishes;
const processSocialProfiles = require('./profile.social').processProfiles;
const {getSocialProviders} = require('./common/socialSetup');
const getDefaultUser = require('./common/checkAuth/getDefaultUser');
const createState = require('./common/createState');
const createPhoneConfirmState = require('./authv2/createPhoneConfirmState');
const createCustomsState = require('./common/createCustomsState');
const getYaExperimentsFlags = require('./common/getYaExperimentsFlags');

const getMethodUrls = (req) => {
    const baseUrlObj = {
        protocol: req.headers['x-real-scheme'],
        hostname: req.hostname
    };
    const currentUrlObj = req._controller.getUrl();
    const RETPATH_2FA = url.format({
        ...baseUrlObj,
        pathname: 'profile/access/2fa',
        query: {
            origin: 'passport_profile'
        }
    });
    const RETPATH_SMS = url.format({...baseUrlObj, pathname: currentUrlObj.pathname, query: {completeSms2fa: 1}});
    const BACKPATH = url.format({...baseUrlObj, pathname: currentUrlObj.pathname, query: {openLoginMethodModal: 1}});

    return {
        login: url.format({
            ...baseUrlObj,
            pathname: 'profile/upgrade',
            query: {origin: 'profile_loginmethod', retpath: req._controller.getUrl()}
        }),
        loginFor2fa: url.format({
            ...baseUrlObj,
            pathname: 'profile/access/2fa/disable',
            query: {origin: 'passport_profile', backpath: BACKPATH}
        }),
        loginAndSmsForNoPortal: url.format({
            ...baseUrlObj,
            pathname: 'profile/upgrade',
            query: {origin: 'profile_loginmethod', retpath: RETPATH_SMS}
        }),
        loginAndSmsFor2fa: url.format({
            ...baseUrlObj,
            pathname: '/profile/access/2fa/disable',
            query: {origin: 'passport_profile', retpath: RETPATH_SMS, backpath: BACKPATH}
        }),
        '2faForPortal': url.format({
            ...baseUrlObj,
            pathname: '/profile/access/2fa',
            query: {origin: 'passport_profile', backpath: BACKPATH}
        }),
        '2faForNoPortal': url.format({
            ...baseUrlObj,
            pathname: '/profile/upgrade',
            query: {origin: 'profile_loginmethod', retpath: RETPATH_2FA}
        }),
        social: url.format({
            ...baseUrlObj,
            pathname: '/profile/social',
            query: {
                backpath: BACKPATH
            }
        })
    };
};

const enter = [
    apiSetup,
    checkAuth,
    getUatraitsData,
    langSetup,
    getYaExperimentsFlags,
    function checkExp(req, res, next) {
        if (req._controller.hasExp('auth_params_exp')) {
            return next();
        }

        return req._controller.redirectToFrontpage();
    },
    multiAuthAccountsSetup,
    createState,
    getMetrics({
        header: 'Способ входа'
    }),
    rumCounterSetup,
    function getTrack(req, res, next) {
        return req.api
            .initTrack({
                type: 'authorize'
            })
            .then(function(response) {
                res.locals.track_id = (response.body && response.body.track_id) || '';
                return next();
            })
            .catch(function(errors) {
                PLog.warn()
                    .logId(req.logID)
                    .type('login-method')
                    .write(errors);

                return next();
            });
    },
    function getState(req, res, next) {
        req.api
            .profileGetState()
            .then((response) => {
                const profile = response.body;

                res.locals.account = profile.account || {};

                return next();
            })
            .catch((errors) => {
                PLog.warn()
                    .logId(req.logID)
                    .type('login-method')
                    .write(errors);

                if (Array.isArray(errors)) {
                    const retpath = url.format(req._controller.getUrl());

                    if (errors.indexOf('sessionid.invalid') !== -1 || errors.indexOf('account.disabled') !== -1) {
                        return res.redirect(
                            url.format(
                                Object.assign({}, req._controller.getAuthUrl(), {
                                    query: {retpath}
                                })
                            )
                        );
                    }

                    if (errors[0].code && errors[0].code === 'unknowntrack') {
                        const query = Object.assign({}, req.query);

                        delete query.track_id;

                        return res.redirect(
                            url.format({
                                protocol: req.headers['x-real-scheme'],
                                hostname: req.hostname,
                                pathname: req.path,
                                query
                            })
                        );
                    }
                }

                return next(errors);
            });
    },
    multiAuthAccountsSetup,
    getSocialProviders,
    function(req, res, next) {
        const {store = {}, account = {}, accounts = {}} = res.locals;
        const defaultAccount = (accounts && accounts.defaultAccount) || {};
        const {default_uid: defaultUid, users} = req.blackbox;
        const defaultUser = getDefaultUser(users, defaultUid);
        const {attributes = {}} = defaultUser;

        store.access = {
            is2faEnabled: account.is_2fa_enabled, // ключ
            isSms2faEnabled: attributes['200'] === '1' // для пароль + смс
        };

        store.person = Object.assign({}, account.person || {}, {
            isSocialchik: defaultAccount.isSocial,
            uid: account.uid,
            loginOptions: defaultAccount.loginOptions,
            hasPhone: defaultAccount.hasPhone,
            hasPublicProfile: defaultAccount.hasPublicProfile,
            hasThirdPartyAccess: defaultAccount.hasThirdPartyAccess,
            havePassword: defaultAccount.havePassword,
            isLiteUser: defaultAccount.is_liteUser,
            isNeoPhonish: defaultAccount.isNeoPhonish,
            isVerifiedAccount: defaultAccount.isVerified,
            errors: {}
        });

        store.social = {
            providers: res.locals.socialProviders.providers.slice().filter((i) => i.enabled),
            profiles:
                (account.profiles && removePhonishes(processSocialProfiles(account.profiles, res.locals.language))) ||
                [],
            brokerPath: config.paths.broker,
            showAllSettings: false,
            allowAuthMethodError: {
                profileId: 0,
                error: ''
            },
            phonishes: [],
            kpshniki: res.locals.kpshniki
        };

        store.phones = {
            restore: [],
            other: [],
            completeSms2fa: req.query.completeSms2fa && req.query.completeSms2fa === '1'
        };

        store.loginMethod = {
            openLoginMethodModal: req.query.openLoginMethodModal && req.query.openLoginMethodModal === '1',
            methodLinks: getMethodUrls(req)
        };

        if (account.phones) {
            Object.keys(account.phones).forEach(function(code) {
                const phone = account.phones[code];

                if (phone.bound) {
                    res.locals.store.phones[phone.secured ? 'restore' : 'other'].push({
                        id: phone.id,
                        number: phone.number.masked_international,
                        isDefault: phone.is_default,
                        isAlias: phone.is_alias
                    });
                }
            });
        }

        return next();
    },
    createPhoneConfirmState,
    createCustomsState,
    function(req, res) {
        const lang = res.locals.language;

        res.render(`react.login-method.${lang}.jsx`);
    }
];

router.get('/', enter);

exports.router = router;

exports.getMethodUrls = getMethodUrls;
