const PLog = require('plog');
const apiSetup = require('./common/apiSetup');
const validateCSRF = require('./common/validateCSRF');

module.exports.saveQuestion = [apiSetup, validateCSRF, saveQuestion];

function saveQuestion(req, res) {
    const body = req.body;
    const data = {
        track_id: body.track_id,
        new_answer: body.newAnswer,
        display_language: body.language
    };

    if (body.ownQuestion) {
        data.question = body.ownQuestion;
    } else {
        data.question_id = body.newQuestionId;
    }
    if (body.oldAnswer) {
        data.answer = body.oldAnswer;
    }
    req.api
        .saveQuestion(data)
        .then(function(apiRes) {
            res.json(apiRes.body);
        })
        .catch(function(err) {
            PLog.warn()
                .logId(req.logID)
                .type('saveQuestion')
                .write(err);
            res.json(err);
        });
}
