var apiSetup = require('./common/apiSetup');
var url = require('url');
var locs = require('../loc/auth.json');
var _ = require('lodash');
var config = require('../configs/current');
var PLog = require('plog');

exports.routes = {};

exports.route = function(app) {
    var routes = this.routes;

    app.all(
        '/passport/?',
        function(req, res, next) {
            if (req.nquery && req.nquery.mode === 'oauth') {
                next();
            } else {
                next('route');
            }
        },
        function(err, req, res, next) {
            if (req.nquery && req.nquery.mode === 'oauth') {
                next();
            } else {
                next('route');
            }
        },
        routes.oauth
    );
};

exports.routes.oauth = [
    function(req, res, next) {
        req.headers.authorization =
            (req.query && req.query.access_token) || req.body.access_token || req.headers.authorization || '';

        delete req.api;
        return next();
    },
    apiSetup,
    doOauthRequest,
    function(error, req, res, next) {
        req._controller
            .getLanguage()
            .then(function(lang) {
                res.locals.language = lang;
            })
            .catch(function(err) {
                res.locals.language = 'ru';

                PLog.warn()
                    .logId(req.logID)
                    .type('oauth error handler')
                    .write(err);
            })
            .done(function() {
                return next(error);
            });
    },
    errorHandler
];

function doOauthRequest(req, res, next) {
    var request = _.extend({}, req.nquery, req.body);
    var data = _.pick(request, ['type', 'retpath']);
    const controller = req._controller;

    if (!data.type) {
        return next(new Error());
    }

    req.api.authSubmit('/1/bundle/auth/oauth/', data).done(function(result) {
        var body = result.body;
        var config = exports.getConfig();
        var pathname;

        if (!(body && body.track_id)) {
            return next(new Error());
        }

        if (body.state) {
            return res.redirect(
                url.format({
                    protocol: req.headers['x-real-scheme'],
                    hostname: req.hostname,
                    pathname: 'auth',
                    query: {
                        track_id: body.track_id,
                        retpath: body.retpath
                    }
                })
            );
        }

        controller.augmentResponse(body);

        if (body.cookies) {
            pathname = `${
                !config.multiauth && body.account && body.account.domain ? `for/${body.account.domain.unicode}` : 'auth'
            }/finish/`;

            return res.redirect(
                url.format({
                    protocol: req.headers['x-real-scheme'],
                    hostname: req.hostname,
                    pathname,
                    query: {
                        track_id: body.track_id
                    }
                })
            );
        } else {
            if (body.retpath) {
                return res.redirect(body.retpath);
            } else {
                return res.redirect(
                    url.format({
                        protocol: req.headers['x-real-scheme'],
                        hostname: req.hostname,
                        pathname: 'passport',
                        query: {
                            mode: 'passport'
                        }
                    })
                );
            }
        }
    }, next);
}

// eslint-disable-next-line no-unused-vars
function errorHandler(err, req, res, next) {
    var retpath = (req.body && req.body.retpath) || (req.nquery && req.nquery.retpath);
    var lang = res.locals.language;
    var loc = locs[lang];
    var auth = {
        protocol: req.headers['x-real-scheme'],
        hostname: req.hostname,
        pathname: 'auth',
        query: {}
    };
    var data;

    if (retpath) {
        auth.query.retpath = _.escape(retpath);
    }

    data = {
        title: loc['Errors']['mode_oauth_error_title'],
        messages: [loc['Errors']['mode_oauth_error_message'].replace('%url%', url.format(auth))]
    };

    return res.render(`auth.message.${lang}.js`, data);
}

function getConfig() {
    return config;
}

exports.getConfig = getConfig;
exports.doOauthRequest = doOauthRequest;
exports.errorHandler = errorHandler;
