var when = require('when');
var PLog = require('plog');
var Api = require('../lib/api/passport');
var getYaExperimentsFlags = require('./common/getYaExperimentsFlags');
var multiAuthAccountsSetup = require('./common/multiAuthAccountsSetup').getAccounts;

var generateRoute = function(Page, isAjax) {
    return function(req, res, next) {
        var logger = new PLog(req.logID, 'passport', 'profile', 'access');
        var controller = req._controller;

        logger.verbose('Hit');

        controller.getLanguage().then(function(lang) {
            controller
                .getAuth()
                .sessionID({
                    // password.2fa_on, account.enable_app_password, glogouttime, revoker.tokens, revoker.app_passwords
                    // and revoker.web_sessions, see https://beta.wiki.yandex-team.ru/passport/dbmoving
                    attributes: '1003,107,4,134,135,136',
                    allow_child: 'yes'
                })
                .then(function(sessionInfo) {
                    var auth = controller.getAuth();
                    var isLoggedIn = Boolean(sessionInfo && sessionInfo.uid && sessionInfo.uid.value);
                    var isSecure = Boolean(sessionInfo && sessionInfo.auth && sessionInfo.auth.secure);

                    if (!isLoggedIn) {
                        if (!isAjax) {
                            auth.authorize();
                        } else {
                            res.send({status: 'error', errors: ['session.required']});
                        }

                        return when.reject();
                    }

                    if (isLoggedIn && !isSecure) {
                        if (!isAjax) {
                            auth.obtainSecureCookie();
                        } else {
                            res.send({status: 'error', errors: ['sslsession.required']});
                        }

                        return when.reject();
                    }

                    return lang;
                })
                .then(function(lang) {
                    var uid = controller.getAuth().getUid();

                    logger.info('User info. Uid: %s, lang: %s', uid, lang);

                    var page = new Page(
                        controller,
                        new Api(req.logID, controller.getHeaders({withPassportServiceTicket: true}), lang, uid),
                        lang
                    );

                    return page.open();
                })
                .catch(function(error) {
                    if (error && error.code === 'need_resign') {
                        return controller.getAuth().resign();
                    }
                    if (error) {
                        next(error);
                    }
                });
        });
    };
};

module.exports = {
    route: function(app) {
        var pageRoute = generateRoute(require('../pages/profile/access/AccessPage'));

        app.all(/\/profile\/access\/?.*/, multiAuthAccountsSetup, pageRoute);
        app.all('/2fa/?', getYaExperimentsFlags, multiAuthAccountsSetup, pageRoute);
    },

    clientside: generateRoute(require('../pages/profile/access/AccessClientside'), true)
};
