/*
 *
 * Deprecated?
 *
 */

var apiSetup = require('./common/apiSetup');
var createCSRFValidator = require('./common/createCSRFValidator');
var _ = require('lodash');
var paths = require('../configs/current').paths;
// var url = require('url');

var RealBlackbox = require('yandex-blackbox');
var bb = new RealBlackbox(paths.blackbox);

var when = require('when');
var controls = require('../pages/profile/address/controls.js');
// var request = require('request');

var countryNames = require('../lib/countries/countries.ru.json');

var PLog = require('plog');

var blackboxFields = {
    phone: 'userphones.number.uid',
    firstname: 'userinfo.firstname.uid',
    lastname: 'userinfo.lastname.uid',
    country: 'userinfo.country.uid',
    city: 'userinfo.city.uid'
};

var getKeyByValue = function(object, value) {
    for (var prop in object) {
        if (object.hasOwnProperty(prop)) {
            if (object[prop] === value) {
                return prop;
            }
        }
    }

    return null;
};

var blackboxUserinfoRequest = function(logID, options, dbfields) {
    //Switching to when's deferred instead of vow's one
    var request = when.defer();

    bb.userinfo(options, dbfields).always(function(result) {
        request.resolve(result.valueOf());
    });

    request.promise.then(function(response) {
        PLog.info()
            .logId(logID)
            .type('passport', 'profile', 'addresses', 'blackboxUserinfoRequest')
            .write('blackbox request responded with %j', response);
    });

    return request.promise;
};

var requestLocations = function(req) {
    return blackboxUserinfoRequest(
        req.logID,
        {
            uid: req._controller.getAuth().getUid(),
            userip: req.ip,
            getlocation: 'postal'
        },
        []
    );
};

var requestBlackboxFields = function(req, fields) {
    return blackboxUserinfoRequest(
        req.logID,
        {
            uid: req._controller.getAuth().getUid(),
            userip: req.ip
        },
        fields
    );
};

var parseBlackboxFields = function(blackboxResponse, fields) {
    var result = {};

    fields.forEach(function(field) {
        result[getKeyByValue(blackboxFields, field)] = '';
    });

    var user = blackboxResponse.users.pop();

    if (user.dbfields) {
        var dbfields = user.dbfields;

        fields.forEach(function(field) {
            result[getKeyByValue(blackboxFields, field)] = dbfields[field] || '';
        });
    }

    return result;
};

var backwardCompability = function(address) {
    if (_.isUndefined(address.recipient)) {
        var recipientConcat = [];

        _.each(['firstname', 'lastname', 'fathersname'], function(key) {
            if (!_.isUndefined(address[key])) {
                recipientConcat.push(address[key]);
            }
        });
        address.recipient = recipientConcat.join(' ');
    }

    return address;
};

var parseLocations = function(reducedLocations) {
    PLog.verbose()
        .type('passport', 'profile', 'addresses', 'parseLocations')
        .write('Parsing locations from %j', reducedLocations);

    var knownLocations = {};
    var user = reducedLocations.users.pop();

    if (user.locations && user.locations.postal) {
        var postal;

        try {
            PLog.verbose()
                .type('passport', 'profile', 'addresses', 'parseLocations')
                .write('Trying to parse %j', user.locations.postal[0]);

            postal = JSON.parse(user.locations.postal[0]);
        } catch (e) {
            //Failed to parse JSON, return an empty object

            PLog.debug()
                .type('passport', 'profile', 'addresses', 'parseLocations')
                .write('Failed to parse json, returning an empty object');

            return knownLocations;
        }

        if (postal.addresses) {
            postal.addresses.forEach(function(location) {
                if (!location.id) {
                    return;
                }

                knownLocations[location.id] = backwardCompability(location);
            });
        }
    }

    PLog.debug()
        .type('passport', 'profile', 'addresses', 'parseLocations')
        .write('Parsed locations into %j', knownLocations);

    return knownLocations;
};

var reduceLocations = function(parsedLocations) {
    return _.map(parsedLocations, function(location) {
        delete location.csrf_token;
        return location;
    });
};

var generateID = function() {
    var date = new Date();

    return String(date.getTime()) + String(Math.round(Math.random() * 100));
};

var serializeLocations = function(parsedLocations) {
    return `{"addresses":${JSON.stringify(reduceLocations(parsedLocations))} }`;
};

// var statusMatcher = new RegExp('.*status="(ok|error)".*');
// var errorMatcher = new RegExp('.*<error>(.*?)</error>.*');
// var getError = function(passportResponse) {
//     var status = statusMatcher.exec(passportResponse);
//
//     if (!status) {
//         return 'Response has no status. Original response: '.passportResponse;
//     }
//
//     status = status[1];
//     if (status === 'ok') {
//         return false;
//     }
//
//     var error = errorMatcher.exec(passportResponse);
//
//     if (!error) {
//         return 'Status not "ok", but no error message found. Original response: '.passportResponse;
//     }
//     return error[1];
// };

// eslint-disable-next-line
var updateAddresses = function(parsedLocations, req, res, next) {
    // var requestBody = serializeLocations(parsedLocations);
    //
    // if (Buffer.byteLength(requestBody, 'utf8') > 4096) {
    //     next('Location size exceeds 4096 bytes: over the limit.');
    //     return;
    // }
    //
    // var uri = url.format({
    //     protocol: 'http',
    //     hostname: '127.0.0.1',
    //     port: 6000,
    //     pathname: 'passport/location',
    //     query: {
    //         mode: 'location',
    //         type: 'postal'
    //     }
    // });
    //
    // request.post(
    //     {
    //         url: uri,
    //         headers: {
    //             Cookie: req.get('cookie'),
    //             Host: paths.internal
    //         },
    //         form: {
    //             text: requestBody
    //         }
    //     },
    //     function(error, response, body) {
    //         error = error || getError(body);
    //
    //         var logger = new PLog(req.logID, 'passport', 'profile', 'addresses', 'updateAddress');
    //
    //         if (error) {
    //             logger.error('Error %s when POSTing to %s with %j', error, uri, requestBody);
    //             next(error);
    //         } else {
    //             logger.info('Server responded with %j after POSTing to %s with %j', body, uri, requestBody);
    //             //Done, show addresses
    //             res.redirect('/profile/address');
    //         }
    //     }
    // );
};

var bodyToParsedLocation = function(body) {
    return _.mapValues(body, function(value) {
        return value.substr(0, 100); //Trunc to 100 chars
    });
};

var init = [
    function(req, res, next) {
        var controller = req._controller;
        var auth = controller.getAuth();

        auth.loggedIn()
            .then(function(loggedIn) {
                if (!loggedIn) {
                    return auth.authorize();
                }

                if (!auth.isSecure()) {
                    return auth.obtainSecureCookie();
                }

                next();
            })
            .catch(function(err) {
                if (err && err.code !== 'need_resign') {
                    return next(err);
                }
            });
    },
    apiSetup,
    function(req, res, next) {
        when(req.api.params('language')).then(
            function(language) {
                var lang = language.body.language;

                res.locals.language = lang;

                req.addressTemplate = `profile.address.${lang}.js`;
                next();
            },
            function(error) {
                next(error);
            }
        );
    },
    function(req, res, next) {
        if (res.locals.language !== 'ru' || res.locals.domain !== 'ru') {
            res.redirect('/passport');
        } else {
            next();
        }
    }
];

var show = [
    function(req, res, next) {
        var requestedFields = [
            blackboxFields.city,
            blackboxFields.country,
            blackboxFields.firstname,
            blackboxFields.lastname
        ];

        when.join(requestBlackboxFields(req, requestedFields), requestLocations(req)).then(
            function(results) {
                var logger = new PLog(req.logID, 'passport', 'profile', 'addresses', 'showAddress');

                //Check if that's an invalid save attempt first
                var locationID = req.body.id || req.params.id;

                var locations = parseLocations(results.pop());
                var canAddAnotherAddress = Buffer.byteLength(serializeLocations(locations), 'utf8') < 3096;

                var personalInfo = parseBlackboxFields(results.pop(), requestedFields);
                var countryCode = personalInfo.country.toUpperCase();

                var errors = req.errors || {};

                if (locationID) {
                    if (errors.length > 0) {
                        locations[req.body.id] = bodyToParsedLocation(req.body);
                    }

                    if (canAddAnotherAddress) {
                        // Show the placeholder for the new address
                        locations['new'] = [
                            {
                                id: 'id',
                                value: 'new'
                            },
                            {
                                id: 'title',
                                value: 'Новый адрес'
                            }
                        ];
                    }
                } else if (canAddAnotherAddress) {
                    // New address form itself
                    locations['new'] = [
                        {
                            id: 'id',
                            value: 'new'
                        },
                        {
                            id: 'country',
                            value: countryNames[countryCode] ? countryNames[countryCode] : ''
                        },
                        {
                            id: 'city',
                            value: personalInfo.city
                        },
                        {
                            id: 'recipient',
                            value: `${personalInfo.firstname} ${personalInfo.lastname}`.trim()
                        }
                    ];
                }

                logger.verbose('Known locations: %j', locations);
                logger.debug('Total locations: %s', _.size(locations));

                var forms = [];

                _.each(locations, function(location, id) {
                    forms.push({
                        form: {
                            id: id,
                            control: _.map(controls, function(control) {
                                var field = _.assign({}, control, {
                                    value: control.id !== 'delete' ? location[control.id] : id
                                });

                                var errCode = errors[control.id];

                                if (errCode) {
                                    var error = _.filter(field.error, {code: errCode}).pop();

                                    if (error) {
                                        error.active = true;
                                    }
                                }

                                return field;
                            }),
                            expand: locationID ? id === locationID : id === 'new'
                        }
                    });
                });

                res.render(req.addressTemplate, {addresses: forms});
            },
            function(err) {
                if (err) {
                    PLog.error()
                        .logId(req.logID)
                        .type('passport', 'profile', 'addresses', 'error')
                        .write(err);
                }

                next(err);
            }
        );
    }
];

exports.address = {};
exports.address.show = init.concat(show);

var checkCkey = createCSRFValidator(
    function(req, res, next) {
        return next();
    },
    function(req, res) {
        return res.redirect('/profile/address');
    }
);

var requiredFields = ['building', 'street', 'city', 'country'];

exports.address.save = [
    init,
    checkCkey,
    [
        function(req, res, next) {
            if (!req.body.id || req.body.id === 'new') {
                req.body.id = generateID();
            }
            var locationID = req.body.id;

            req.errors = {};
            requiredFields.forEach(function(field) {
                var value = req.body[field];

                if (typeof value !== 'string' || value.length === 0) {
                    req.errors[field] = 'missingvalue';
                }
            });

            if (_.size(req.errors) > 0) {
                next(); //Skip to showing the form again
            } else {
                when(requestLocations(req)).then(function(locations) {
                    locations = parseLocations(locations);
                    locations[locationID] = bodyToParsedLocation(req.body);

                    updateAddresses(locations, req, res, next);
                });
            }
        }
    ],
    show
];

exports.address.delete = [
    init,
    checkCkey,
    [
        function(req, res, next) {
            if (req.body.id) {
                when(requestLocations(req)).then(function(locations) {
                    locations = parseLocations(locations);
                    delete locations[req.body.id];

                    updateAddresses(locations, req, res, next);
                });
            } else {
                next();
            }
        }
    ],
    show
];
