var API = require('./common/apiSetup');
var PLog = require('plog');
var PForm = require('pform');
var pathname = '/profile/areyourobot';
var _ = require('lodash');
var url = require('url');
var when = require('when');

exports.route = function(app) {
    app.get(pathname, this.setup)
        .post(pathname, this.submit)
        .all(pathname, this.enter);
};

function getForm() {
    return new PForm(
        new (require('../blocks/control/captcha/captcha.field'))()
            .setLabel('%profile_hack_page_header')
            .setHint('%profile_hack_page_description')
            .setOption('asyncCheck', true)
            .setRequired(),
        new (require('../blocks/control/submit/submit.field'))().setOption('theme', 'action').setLabel('%confirm_code')
    );
}

function redirectUser(req, res) {
    var controller = req._controller;
    var modePassportUrl = url.format(controller.getModePassportUrl());

    if (!req.nquery || !req.nquery.retpath) {
        PLog.info()
            .logId(req.logID)
            .type('hack')
            .write('Redirect to passport', res.locals.track_id);

        return res.redirect(modePassportUrl);
    }

    req.api.validateRetpath({retpath: req.nquery.retpath}).then(function(data) {
        if (!data.body.retpath) {
            PLog.info()
                .logId(req.logID)
                .type('hack')
                .write('Redirect to passport', res.locals.track_id);

            return res.redirect(modePassportUrl);
        }

        PLog.info()
            .logId(req.logID)
            .type('hack')
            .write('Redirect to', data.body.retpath, res.locals.track_id);

        return res.redirect(data.body.retpath);
    });
}

function writeToStatbox(req, res, type, uid) {
    const experimentFlags = res.locals.experiments && res.locals.experiments.flagsString;
    const experimentBoxes = res.locals.experiments && res.locals.experiments.boxes;

    var log = _.extend(
        {
            action: 'opened',
            mode: 'profile_hack',
            track_id: res.locals.track_id || null,
            ip: req.headers['x-real-ip'],
            host: req.hostname,
            user_agent: req.headers['user-agent'],
            yandexuid: req.cookies.yandexuid,
            experiment_flags: experimentFlags,
            experiment_boxes: experimentBoxes
        },
        res.accountInfo
    );

    switch (type) {
        case 'whiteSession':
            log.action = 'redirect_with_white_session';
            break;
        case 'success':
            log.action = 'success_captcha_check';
            break;
        case 'setKarma':
            log.action = 'set_karma';
            log.uid = uid;
            log.isDefault = (uid.toString() === log.default_uid).toString();

            break;
    }

    req.api.statboxLogger(log);
}

var getSessionInfo = [
    function(req, res, next) {
        var controller = req._controller;

        controller
            .getAuth()
            .sessionID({
                method: 'sessionid',
                multisession: 'yes',
                authid: 'yes'
            })
            .then(function(sessioninfo) {
                req.blackbox = sessioninfo || {};
                return next();
            })
            .catch(function(error) {
                if (error && error.code === 'need_resign') {
                    return controller.getAuth().resign();
                }

                if (error) {
                    return next(error);
                }
            });
    },
    function(req, res, next) {
        if (!req.blackbox) {
            return next();
        }

        res.authid = req.blackbox.authid;
        res.accountInfo = {
            session_fraud: req.blackbox.session_fraud,
            authid: req.blackbox.authid && req.blackbox.authid.id,
            default_uid: req.blackbox.default_uid
        };

        res.accountInfo.users = req.blackbox.users.length
            ? req.blackbox.users.map(function(user) {
                  return user && user.uid && user.uid.value;
              })
            : [];

        if (req.blackbox.session_fraud === 0) {
            writeToStatbox.call(this, req, res, 'whiteSession');
            return redirectUser.apply(this, arguments);
        }

        next();
    }
];

exports.setup = [
    function(req, res, next) {
        var controller = req._controller;

        controller
            .getAuth()
            .loggedIn()
            .then(function(loggedIn) {
                if (!loggedIn) {
                    return res.redirect(
                        url.format(
                            _.extend(controller.getUrl(), {
                                pathname: '/auth',
                                query: null,
                                search: null
                            })
                        )
                    );
                }
                next();
            })
            .catch(function(err) {
                if (err && err.code !== 'need_resign') {
                    next(err);
                }
            });
    },
    API,
    function(req, res, next) {
        req.api.getTrack().then(
            function(data) {
                if (data.body && data.body.id) {
                    res.locals.track_id = data.body.id;
                }

                next();
            },
            function(err) {
                next(err);
            }
        );
    },
    function(req, res, next) {
        next('route');
    }
];

exports.enter = [
    function(err, req, res, next) {
        res.formErrors = err;
        next();
    },
    function(req, res, next) {
        var controller = req._controller;

        controller
            .getLanguage()
            .then(function(lang) {
                res.locals.language = lang;
            })
            .catch(function(err) {
                res.locals.language = 'ru';

                PLog.warn()
                    .logId(req.logID)
                    .type('hack')
                    .write(err);
            })
            .done(function() {
                return next();
            });
    },
    getSessionInfo,
    function(req, res, next) {
        writeToStatbox.call(this, req, res);

        var form = getForm().setApi(req.api);

        if (res.formErrors && res.formErrors.length) {
            res.formErrors.forEach(function(code) {
                var splitedCode = code.split('.');
                var fieldName = splitedCode[0];
                var field = form.getField(fieldName);

                if (field) {
                    var err = field.getErrorByCode(splitedCode[1]);

                    if (err) {
                        err.setActive();
                    }
                }
            });
        }

        form.compile(res.locals.language).then(
            function(data) {
                res.locals.form = {
                    control: data
                };

                next();
            },
            function(err) {
                next(err);
            }
        );
    },
    function(req, res) {
        res.render(`profile.hack.${res.locals.language}.js`);
    }
];

exports.submit = [
    API,
    function(req, res, next) {
        res.locals.track_id = req.body.track_id;

        if (!req.body.key) {
            return next();
        }

        req.api.captchaCheckStatus(req.body).then(
            function(data) {
                var body = (data && data.body) || null;

                if (body && body.is_recognized && body.is_checked) {
                    return next();
                }

                req.api.captchaCheck(req.body).then(
                    function(data) {
                        delete req.body.answer;
                        if (data.body.correct) {
                            next();
                        } else {
                            next(['answer.incorrect']);
                        }
                    },
                    function() {
                        next(['answer.captchalocate']);
                    }
                );
            },
            function(err) {
                next(err);
            }
        );
    },
    getSessionInfo,
    function(req, res, next) {
        var requests = res.accountInfo.users.map(function(uid) {
            return req.api.setKarma({
                auth_id: res.accountInfo.authid,
                karma: 0,
                uid
            });
        });
        var self = this;

        when.all(requests).then(function(results) {
            results.forEach(function(result) {
                var date = new Date();

                if (result.body.status === 'ok') {
                    writeToStatbox.call(self, req, res, 'setKarma', result.body.uid);
                    req.api.feedbackForBigBro({
                        uid: result.body.uid,
                        authid: res.authid,
                        ts: String(Math.round(date.getTime() / 1000) + date.getTimezoneOffset() * 60),
                        ip: req.headers['x-real-ip'],
                        type: 6
                    });
                }
            });

            writeToStatbox.call(self, req, res, 'success');
            next();
        });
    },
    redirectUser
];
