const url = require('url');
const PLog = require('plog');
const dayjs = require('dayjs');
const relativeTime = require('dayjs/plugin/relativeTime');

const config = require('../configs/current');
const apiSetup = require('./common/apiSetup');
const checkAuth = require('./common/checkAuth');
const langSetup = require('./common/langSetup');
const getUatraitsData = require('./common/getUatraitsData');
const getMetrics = require('./common/getMetrics');
const apiRequest = require('./authv2/apiRequest.js');
const rumCounterSetup = require('./common/rumCounterSetup');
const multiAuthAccountsSetup = require('./common/multiAuthAccountsSetup').getAccounts;
const geoCountries = require('../lib/geo/countries.json');

dayjs.extend(relativeTime);

const renderPage = (req, res) => {
    const lang = res.locals.language;
    const experimentFlags = res.locals.experiments && res.locals.experiments.flagsString;
    const experimentBoxes = res.locals.experiments && res.locals.experiments.boxes;

    req.api.statboxLogger({
        action: 'opened',
        host: req.hostname,
        pathname: req.path,
        ip: req.headers['x-real-ip'],
        yandexuid: req.cookies.yandexuid,
        mode: 'profile.passport.intranet',
        user_agent: req.headers['user-agent'],
        referer: req.headers.referer || null,
        track_id: res.locals.track_id || null,
        origin: (req.query && req.query.origin) || null,
        uid: (res.locals.store && res.locals.store.person && res.locals.store.person.uid) || null,
        experiment_flags: experimentFlags,
        experiment_boxes: experimentBoxes
    });

    res.render(`profile.passport_intranet.${lang}.jsx`);
};

const createStore = (req, res, next) => {
    // eslint-disable-line complexity
    const locals = res.locals;
    const account = locals.account;
    const uatraits = locals.ua || {};
    const tld = req._controller.getTld();
    const accounts = locals.accounts || {};
    const {validateRetpath: {retpath} = {}} = locals.result || {};
    const defaultAccount = accounts.defaultAccount || {};
    const links = config.links.intranet || config.links.ru || {};
    const embeddedauth = config.paths.embeddedauth.replace('%tld%', tld);
    const yandexuid = res._yandexuid && res._yandexuid.replace(/[^0-9]/g, '');
    const lastUpdate = account.password_info && account.password_info.last_update;

    let personCountry = '';

    if (account.person.country) {
        const locsCountries = geoCountries[locals.language];

        personCountry = ((locsCountries || []).filter((country) => country.iso === account.person.country)[0] || {})
            .name;
    }

    const {paths = {}, version} = config;
    const {static: staticPath} = paths;
    const {userType = {}} = locals;
    const {metricsUserType} = userType;

    locals.store = {
        am: {},
        settings: {
            tld,
            links,
            ua: uatraits,
            embeddedauth,
            location: req.path,
            language: locals.language,
            help: config.paths.help || {},
            avatar: config.paths.avatar || {},
            soundManagerPath: config.paths.soundManager,
            isTouch: uatraits.isMobile || uatraits.isTouch,
            isPhone: (uatraits.isMobile || uatraits.isTouch) && !uatraits.isTablet,
            logoutURL: `${embeddedauth}&yu=${yandexuid}&action=logout&uid=${account.uid}&retpath=${links.yandex}`,
            host: url.format({
                protocol: req.headers['x-real-scheme'],
                hostname: req.hostname
            }),
            env: {
                type: process.env.NODE_ENV,
                name: process.env.INTRANET
            },
            accountsUrl: config.paths.accountsUrl,
            version,
            metricsUserType,
            staticPath
        },
        access: {
            is2faEnabled: account.is_2fa_enabled,
            isAppPasswordsEnabled: account.app_passwords_enabled,
            passwordInfo: account.password_info
                ? Object.assign({}, account.password_info, {
                      timeFromUpdate: lastUpdate
                          ? dayjs()
                                .locale(locals.language)
                                .subtract(new Date().getTime() - lastUpdate * 1000, 'ms')
                                .fromNow()
                          : ''
                  })
                : {},
            featureHint: ''
        },
        common: {
            retpath,
            yandexuid,
            currentPage: req._controller.getUrl().href
        },
        captcha: {
            loading: false,
            playing: false,
            type: 'text',
            key: null,
            imageUrl: null,
            introSound: null,
            captchaSound: null
        },
        person: Object.assign({}, account.person || {}, {
            uid: account.uid,
            login: account.login,
            city: account.person.city || '',
            countryName: personCountry,
            birthday: account.person.birthday || '',
            displayLogin: account.display_login || '',
            displayName: defaultAccount.displayName || '',
            isDisplayNameEmpty: defaultAccount.isDisplayNameEmpty,
            publicDisplayName: defaultAccount.publicDisplayName || '',
            avatarId: (account.display_name && account.display_name.default_avatar) || ''
        }),
        header: {
            defaultAccount,
            accounts: accounts.accounts || [],
            canAddMore: accounts['can-add-more']
        },
        rfcTotp: {
            qrSVG: null,
            secret: ''
        },
        monitoring: {
            page: 'passport.intranet'
        }
    };

    return next();
};

const getState = (req, res, next) =>
    req.api
        .profileGetState()
        .then(({body = {}}) => {
            res.locals.account = body.account || {};
            return next();
        })
        .catch((errors) => {
            PLog.warn()
                .logId(req.logID)
                .type('profile.passport.intranet')
                .write(errors);
            if (Array.isArray(errors)) {
                const retpath = url.format(req._controller.getUrl());

                if (errors.indexOf('sessionid.invalid') !== -1 || errors.indexOf('account.disabled') !== -1) {
                    return res.redirect(
                        url.format(
                            Object.assign({}, req._controller.getAuthUrl(), {
                                query: {retpath}
                            })
                        )
                    );
                }

                if (errors[0].code && errors[0].code === 'unknowntrack') {
                    const query = Object.assign({}, req.query);

                    delete query.track_id;

                    return res.redirect(
                        url.format({
                            protocol: req.headers['x-real-scheme'],
                            hostname: req.hostname,
                            pathname: req.path,
                            query
                        })
                    );
                }
            }

            return next(errors);
        });

const getTrack = (req, res, next) =>
    req.api
        .initTrack({
            type: 'authorize'
        })
        .then((response) => {
            res.locals.track_id = (response.body && response.body.track_id) || '';
            return next();
        })
        .catch((errors) => {
            PLog.warn()
                .logId(req.logID)
                .type('profile.passport.intranet')
                .write(errors);
            return next();
        });

const enter = [
    checkAuth,
    multiAuthAccountsSetup,
    langSetup,
    getUatraitsData,
    apiSetup,
    getTrack,
    getState,
    apiRequest('validateRetpath'),
    createStore,
    getMetrics({header: 'Профиль интранет'}),
    rumCounterSetup,
    renderPage
];

module.exports = (app) => app.get('/profile', enter).get('/profile/password', enter);
