const express = require('express');
const router = express.Router();
const PLog = require('plog');
const langSetup = require('./common/langSetup');
const multiAuthAccountsSetup = require('./common/multiAuthAccountsSetup').getAccounts;
const apiSetup = require('./common/apiSetup');
const getUatraitsData = require('./common/getUatraitsData');
const writeStatbox = require('./common/writeStatbox');
const generateProcessUUID = require('./authv2/generateProcessUUID');
const checkAuth = require('./common/checkAuth');
const showPlus = require('./common/plusGuard').showPlus;
const rumCounterSetup = require('./common/rumCounterSetup');
const createState = require('./common/createState');
const validateRetpath = require('./common/validateRetpath');
const getYaExperimentsFlags = require('./common/getYaExperimentsFlags');
const getMetrics = require('./common/getMetrics');

const enter = [
    apiSetup,
    checkAuth,
    getYaExperimentsFlags,
    getUatraitsData,
    langSetup,
    rumCounterSetup,
    function getTrack(req, res, next) {
        req.api
            .getTrack({}, true)
            .then(function(result) {
                res.locals.track_id = result.body.track_id;
                return next();
            })
            .catch((error) => {
                PLog.warn()
                    .logId(req.logID)
                    .type('public_id, getTrack')
                    .write(error);
                return next();
            });
    },
    generateProcessUUID,
    validateRetpath,
    showPlus,
    function(req, res, next) {
        if (res.locals.showPlus) {
            res.locals.blackboxPlus = true;
        }

        return next();
    },
    multiAuthAccountsSetup,
    (req, res, next) => {
        req.api
            .profileGetState()
            .then((response = {}) => {
                const {body = {}} = response;
                const {account = {}} = body;

                res.locals.account = account;

                return next();
            })
            .catch((error) => {
                PLog.warn()
                    .logId(req.logID)
                    .type('profile-publicId, getAccountInfo')
                    .write(error);
                return next();
            });
    },
    createState,
    function getPublicId(req, res, next) {
        const params = {
            need_display_name_variants: true,
            need_phones: false,
            need_emails: false,
            need_social_profiles: false,
            need_question: false,
            need_additional_account_data: false
        };

        return req.api
            .profileGetState(params)
            .then((response) => {
                if (response && response.body) {
                    const account = response.body.account || {};
                    const {public_id} = account;

                    res.locals.publicId = public_id;
                }

                return next();
            })
            .catch((error) => {
                PLog.warn()
                    .logId(req.logID)
                    .type('public_id, getPublicId')
                    .write(error);
                return next();
            });
    },
    function updateState(req, res, next) {
        const {store = {}, userType = {}, validRetpath} = res.locals;
        const {isPortal} = userType;
        const defaultAccount = (store.header || {}).defaultAccount;
        const hasPublicIdSet = defaultAccount.hasPublicIdSet;
        const isPopupMode = req.query && req.query.mode === 'popup';

        store.publicId = {
            hasUpdated: false,
            showLoginInSuggest: isPortal,
            updatesNumber: 0,
            hasPublicIdSet,
            publicIdSuggest: [],
            id: hasPublicIdSet ? res.locals.publicId : '',
            isPopupMode
        };

        store.common.csrf = res.locals.csrf;

        if (validRetpath) {
            store.common.retpath = validRetpath;
        }

        res.locals.isPopupMode = isPopupMode;

        return next();
    },
    writeStatbox({
        action: 'opened',
        mode: 'public_id'
    }),
    getMetrics({
        header: 'Страница добавления и редактирования public_id'
    }),
    renderPage
];

router.get('/', enter);
router.post('/', enter);

function renderPage(req, res) {
    const lang = res.locals.language;

    res.removeHeader('X-Frame-Options');
    res.render(`react.public-id.${lang}.jsx`);
}

exports.router = router;
