const PLog = require('plog');
const langSetup = require('./common/langSetup');
const apiSetup = require('./common/apiSetup');
const getUatraitsData = require('./common/getUatraitsData');
const getYaExperimentsFlags = require('./common/getYaExperimentsFlags');
const createSecurityState = require('./security/createState');
const createState = require('./common/createState');
const getCountry = require('./common/getCountry');
const getAccountInfo = require('./security/getAccountInfo');
const multiAuthAccountsSetup = require('./common/multiAuthAccountsSetup').getAccounts;
const getMetrics = require('./common/getMetrics');
const showPlus = require('./common/plusGuard').showPlus;
const rumCounterSetup = require('./common/rumCounterSetup');
const createCustomsState = require('./common/createCustomsState');

module.exports = [
    apiSetup,
    getYaExperimentsFlags,
    function checkExp(req, res, next) {
        const experimentsFlags = (res.locals.experiments && res.locals.experiments.flags) || [];
        const isSecurityPageExp = experimentsFlags.includes('passport-security-v2-exp');

        if (isSecurityPageExp) {
            return next();
        }

        return next('route');
    },
    getUatraitsData,
    langSetup,
    function getTrack(req, res, next) {
        return req.api
            .initTrack({
                type: 'authorize'
            })
            .then(function(response) {
                res.locals.track_id = (response.body && response.body.track_id) || '';
                return next();
            })
            .catch(function(errors) {
                PLog.warn()
                    .logId(req.logID)
                    .type('profile.security.getTrack')
                    .write(errors);

                return next();
            });
    },
    getCountry,
    showPlus,
    function(req, res, next) {
        if (res.locals.showPlus) {
            res.locals.blackboxPlus = true;
        }

        return next();
    },
    multiAuthAccountsSetup,
    createState,
    createSecurityState,
    createCustomsState,
    getAccountInfo,
    getMetrics({
        header: 'Страница безопасности v2'
    }),
    rumCounterSetup,
    (req, res) => {
        const {forced, track_id} = req.query;
        const lang = res.locals.language;

        if (forced === '1') {
            if (res.locals.store.common) {
                res.locals.store.common.loadCustomsStyles = true;
                res.locals.store.common.forced = true;
                res.locals.store.common.additionalDataRequestTrackId = track_id;
            } else {
                res.locals.store.common = {
                    loadCustomsStyles: true,
                    forced: true,
                    additionalDataRequestTrackId: track_id
                };
            }
        }

        res.render(`react.security.${lang}.jsx`);
    }
];
