const PLog = require('plog');
const apiSetup = require('./common/apiSetup');
const KinopoiskApi = require('../lib/api/kinopoisk');

exports.kinopoiskGetDefaultSelection = [
    apiSetup,
    (req, res) => {
        const {selectionWindowId} = req.body;

        return new KinopoiskApi(req.logID, req.get('User-Agent'))
            .getSelection(`/${selectionWindowId}`)
            .then((response) => {
                const responseCollections = (response && response.collections) || [];

                if (responseCollections == null || responseCollections[0] == null) {
                    return res.json([]);
                }
                const data = responseCollections[0].data;
                const urls = data.map((filmData) => filmData.horizontalPoster);

                return res.json(urls);
            })
            .catch((err) => {
                PLog.warn()
                    .logId(req.logID)
                    .type('profile.subscriptions.KinopoiskApi.getSelection')
                    .write(err);
                return res.json({status: 'error'});
            });
    }
];
