const PLog = require('plog');
const when = require('when');
const url = require('url');
const configCommon = require('../configs/common');
const langSetup = require('./common/langSetup');
const apiSetup = require('./common/apiSetup');
const checkAuth = require('./common/checkAuth');
const getUatraitsData = require('./common/getUatraitsData');
const getYaExperimentsFlags = require('./common/getYaExperimentsFlags');
const createState = require('./common/createState');
const getCountry = require('./common/getCountry');
const multiAuthAccountsSetup = require('./common/multiAuthAccountsSetup').getAccounts;
const getMetrics = require('./common/getMetrics');
const showPlus = require('./common/plusGuard').showPlus;
const rumCounterSetup = require('./common/rumCounterSetup');
const {postVerificationForm, postVerificationFormPPL} = require('./accountVerification/api');

const verificationPage = [
    apiSetup,
    getYaExperimentsFlags,
    function checkExp(req, res, next) {
        const {experiments} = res.locals;
        const {flags} = experiments || {};

        return (flags || []).includes('profile-verification-enable') ? next() : next('route');
    },
    getUatraitsData,
    langSetup,
    function getTrack(req, res, next) {
        return req.api
            .initTrack({
                type: 'authorize'
            })
            .then(function(response) {
                res.locals.track_id = (response.body && response.body.track_id) || '';
                return next();
            })
            .catch(function(errors) {
                PLog.warn()
                    .logId(req.logID)
                    .type('profile.verification.getTrack')
                    .write(errors);

                return next();
            });
    },
    getCountry,
    showPlus,
    function(req, res, next) {
        if (res.locals.showPlus) {
            res.locals.blackboxPlus = true;
        }

        return next();
    },
    multiAuthAccountsSetup,
    (req, res, next) => {
        req.api
            .profileGetState()
            .then((response = {}) => {
                const {body = {}} = response;
                const {account = {}} = body;

                res.locals.account = account;

                return next();
            })
            .catch((error) => {
                PLog.warn()
                    .logId(req.logID)
                    .type('profile-verification, getAccountInfo')
                    .write(error);
                return next();
            });
    },
    createState,
    getMetrics({
        header: 'Страница верификации'
    }),
    async (req, res, next) => {
        const {store} = res.locals;
        const {header, settings} = store;
        const {defaultAccount} = header || {};
        const {mail, publicDisplayName, name} = defaultAccount || {};
        const {tld = 'ru'} = settings || {};

        const retpath = url.format({
            protocol: req.headers['x-real-scheme'],
            hostname: req.hostname,
            pathname: req.path
        });

        const authLink = url.format({
            protocol: req.headers['x-real-scheme'],
            hostname: req.hostname,
            pathname: '/auth',
            query: {retpath}
        });

        store.domik = {
            errors: {},
            requestPassword: false,
            requestCaptcha: false,
            passwordNotMatched: false,
            captchaNotMatched: false,
            loading: false
        };
        store.common.csrf = res.locals.csrf;

        if (!req._controller.getAuth().isLoggedIn()) {
            store.verification = {isLoggedIn: false, authLink};
            return next();
        }

        const {body: {account} = {}} = await req.api.profileGetState();

        const {phones = {}, emails = {}, public_id: publicId} = account;

        const phone = (() => {
            const arr = [];

            for (const p in phones) {
                if (!phones.hasOwnProperty(p)) {
                    continue;
                }

                if (phones[p].secured && phones[p].bound && phones[p].number) {
                    return {
                        number: phones[p].number.original
                    };
                }

                if (phones[p].number) {
                    arr.push({
                        secured: phones[p].secured,
                        bound: phones[p].bound,
                        number: phones[p].number.original,
                        operation: phones[p].operation,
                        phoneId: phones[p].id
                    });
                }
            }

            return arr[0];
        })();

        const email = (emails.suitable_for_restore || [])[0];

        const links = configCommon.legalLinks;

        links.rules = links.rules.replace('%tld%', tld);
        links.confidential = links.confidential.replace('%tld%', tld);

        store.verification = {
            isLoggedIn: true,
            user: {
                publicName: publicDisplayName,
                login: mail,
                publicId,
                name
            },
            phone: {
                value: (phone && phone.number) || '',
                isConfirmed: Boolean(phone && phone.number && !phone.operation),
                isConfirmInProgress: false
            },
            email: {
                value: email || '',
                isConfirmed: Boolean(email),
                isConfirmInProgress: false
            },
            photoSrc: '',
            socials: [''],
            reason: '',
            checkboxes: {
                isAcceptTerms: false,
                isAcceptVerification: false
            },
            authLink,
            isLoading: false,
            links
        };

        next();
    },
    rumCounterSetup,
    (req, res) => {
        res.render(`react.verification.${res.locals.language}.jsx`);
    }
];

const verificationPagePpl = [
    apiSetup,
    checkAuth,
    getYaExperimentsFlags,
    function checkExp(req, res, next) {
        const {experiments} = res.locals;
        const {flags} = experiments || {};

        return (flags || []).includes('profile-verification-enable') ? next() : next('route');
    },
    getUatraitsData,
    langSetup,
    function getTrack(req, res, next) {
        return req.api
            .initTrack({
                type: 'authorize'
            })
            .then(function(response) {
                res.locals.track_id = (response.body && response.body.track_id) || '';
                return next();
            })
            .catch(function(errors) {
                PLog.warn()
                    .logId(req.logID)
                    .type('profile.verification.getTrack')
                    .write(errors);

                return next();
            });
    },
    getCountry,
    showPlus,
    function(req, res, next) {
        if (res.locals.showPlus) {
            res.locals.blackboxPlus = true;
        }

        return next();
    },
    multiAuthAccountsSetup,
    (req, res, next) => {
        req.api
            .profileGetState()
            .then((response = {}) => {
                const {body = {}} = response;
                const {account = {}} = body;

                res.locals.account = account;

                return next();
            })
            .catch((error) => {
                PLog.warn()
                    .logId(req.logID)
                    .type('profile-verification, getAccountInfo')
                    .write(error);
                return next();
            });
    },
    createState,
    getMetrics({
        header: 'Страница верификации'
    }),
    async (req, res, next) => {
        const {store} = res.locals;
        const {header, settings} = store;
        const {defaultAccount} = header || {};
        const {mail, publicDisplayName, name} = defaultAccount || {};
        const {tld = 'ru'} = settings || {};
        const serpUri = req.query && req.query.serp_uri;
        const handlers = [];

        if (serpUri) {
            handlers.push(req.api.validateRetpath({retpath: serpUri}));
        }

        const retpath = url.format({
            protocol: req.headers['x-real-scheme'],
            hostname: req.hostname,
            pathname: req.path
        });

        const authLink = url.format({
            protocol: req.headers['x-real-scheme'],
            hostname: req.hostname,
            pathname: '/auth',
            query: {retpath}
        });

        store.domik = {
            errors: {},
            requestPassword: false,
            requestCaptcha: false,
            passwordNotMatched: false,
            captchaNotMatched: false,
            loading: false
        };
        store.common.csrf = res.locals.csrf;

        if (!req._controller.getAuth().isLoggedIn()) {
            store.verification = {isLoggedIn: false, authLink};
            return next();
        }

        const {body: {account} = {}} = await req.api.profileGetState();

        const {emails = {}, public_id: publicId} = account;

        const email = (emails.suitable_for_restore || [])[0];

        const links = configCommon.legalLinks;

        links.rules = links.rules.replace('%tld%', tld);
        links.confidential = links.confidential.replace('%tld%', tld);
        links.landingPpl = '#';

        store.verification = {
            isPplMode: true,
            isLoggedIn: true,
            user: {
                publicName: publicDisplayName,
                login: mail,
                publicId,
                name
            },
            email: {
                value: email || '',
                isConfirmed: Boolean(email),
                isConfirmInProgress: false
            },
            photoSrc: '',
            reason: '',
            socials: [''],
            checkboxes: {
                isAcceptTerms: false,
                isAcceptVerification: false,
                isAcceptDelete: false
            },
            authLink,
            isLoading: false,
            links
        };

        when.all(handlers)
            .then(function(response) {
                const validatedSerpUri = response[0] || {};

                if (validatedSerpUri.body && validatedSerpUri.body.retpath) {
                    store.verification.serpUri = validatedSerpUri.body.retpath;
                }
                return next();
            })
            .catch(function(err) {
                PLog.warn()
                    .logId(req.logID)
                    .type('verification_serp_uri_error')
                    .write(err);
            })
            .done(function() {
                return next();
            });
    },
    rumCounterSetup,
    (req, res) => {
        res.render(`react.verification.${res.locals.language}.jsx`);
    }
];

exports.route = function(app) {
    app.get('/profile/verification', verificationPage);
    app.post('/profile/verification', postVerificationForm);

    app.get('/profile/ppl', verificationPagePpl);
    app.post('/profile/ppl', postVerificationFormPPL);
};
