const langSetup = require('./common/langSetup');
const apiSetup = require('./common/apiSetup');
const getMetrics = require('./common/getMetrics');
const createState = require('./common/createState');
const createAMState = require('./authv2/createAMState');
const validateAMParams = require('./authv2/validateAMParams');
const multiAuthAccountsSetup = require('./common/multiAuthAccountsSetup').getAccounts;
const userIsValid = require('./common/checkAuth/userIsValid');
const rumCounterSetup = require('./common/rumCounterSetup');
const setTheme = require('./authv2/setTheme');
const dayjs = require('dayjs');
const express = require('express');
const router = express.Router();

const enter = [
    apiSetup,
    langSetup,
    createState,
    validateAMParams,
    createAMState,
    userIsValid,
    function(req, res, next) {
        const {store = {}} = res.locals;
        const {
            am: {isAm, finishErrorUrl}
        } = store;

        if (isAm && !res.locals.userIsValid) {
            return req._controller.redirect(finishErrorUrl);
        }

        return next();
    },
    getMetrics({
        header: 'Пуш о подозрительном входе'
    }),
    rumCounterSetup,
    multiAuthAccountsSetup,
    function(req, res, next) {
        const {store = {}, accounts: {accounts = []} = {}} = res.locals;
        const {
            am: {uid}
        } = store;
        const currentAccount = accounts.find((account) => account.uid === uid);

        if (!currentAccount) {
            store.person = Object.assign(
                {},
                {
                    isAccountError: true
                }
            );

            return next();
        }

        const {havePassword, avatarId, login, name, publicDisplayName, displayName} = currentAccount;

        store.person = Object.assign(
            {},
            {
                havePassword,
                avatarId,
                login,
                name,
                publicDisplayName,
                displayName,
                isAccountError: false
            }
        );

        return next();
    },
    function(req, res, next) {
        res.locals.ua = {
            isTouch: true
        };

        return next();
    },
    function(req, res, next) {
        const {location, ip, map_url, timestamp, browser_name, title_key = 'default'} = req.query;
        const {store = {}} = res.locals;
        const lang = res.locals.language;

        store.activityAlert = {
            isShowNotMe: false,
            location,
            ip,
            mapUrl: map_url ? map_url.replace('&pt=', '&ll=') : '',
            browserName: browser_name,
            date: timestamp
                ? dayjs(timestamp * 1000)
                      .locale(lang)
                      .format(`D${lang === 'en' ? ' [of] ' : ' '}MMMM[,] HH:mm`)
                : '',
            titleKey: title_key
        };

        return next();
    },
    setTheme,
    function renderPage(req, res) {
        const lang = res.locals.language;

        res.render(`react.push-activity-alert.${lang}.jsx`);
    }
];

router.get('/', enter);
exports.router = router;
