const langSetup = require('./common/langSetup');
const apiSetup = require('./common/apiSetup');
const getMetrics = require('./common/getMetrics');
const createState = require('./common/createState');
const createCommonState = require('./authv2/createCommonState');
const createAMState = require('./authv2/createAMState');
const validateAMParams = require('./authv2/validateAMParams');
const createCustomsState = require('./common/createCustomsState');
const getYaExperimentsFlags = require('./common/getYaExperimentsFlags');
const rumCounterSetup = require('./common/rumCounterSetup');
const express = require('express');
const router = express.Router();

const enter = [
    apiSetup,
    langSetup,
    getYaExperimentsFlags,
    createState,
    function(req, res, next) {
        if (res.locals.store.common) {
            res.locals.store.common.loadCustomsStyles = true;
        }

        return next();
    },
    createCustomsState,
    createCommonState(),
    validateAMParams,
    createAMState,
    getMetrics({
        header: 'Форма ввода пуша'
    }),
    function updateState(req, res, next) {
        const {store = {}} = res.locals;

        store.pushAuth = {
            codeValue: ''
        };
        return next();
    },
    rumCounterSetup,

    function renderPage(req, res) {
        const lang = res.locals.language;

        res.render(`react.push-auth.${lang}.jsx`);
    }
];

router.get('/', enter);
exports.router = router;
