const PLog = require('plog');
const langSetup = require('./common/langSetup');
const apiSetup = require('./common/apiSetup');
const getMetrics = require('./common/getMetrics');
const createState = require('./common/createState');
const createAMState = require('./authv2/createAMState');
const userIsValid = require('./common/checkAuth/userIsValid');
const validateAMParams = require('./authv2/validateAMParams');
const rumCounterSetup = require('./common/rumCounterSetup');
const setTheme = require('./authv2/setTheme');
const express = require('express');
const router = express.Router();

const enter = [
    apiSetup,
    langSetup,
    createState,
    function(req, res, next) {
        res.locals.ua = {
            isTouch: true
        };

        return next();
    },
    validateAMParams,
    createAMState,
    userIsValid,
    function(req, res, next) {
        const {store = {}} = res.locals;
        const {
            am: {isAm, finishErrorUrl}
        } = store;

        if (isAm && !res.locals.userIsValid) {
            req._controller.redirect(finishErrorUrl);
            return;
        }

        return next();
    },
    getMetrics({
        header: 'Попап с пушем'
    }),
    function getCode(req, res, next) {
        const {store = {}} = res.locals;
        const {
            am: {trackId}
        } = store;

        req.api
            .getCode(trackId)
            .then((result = {}) => {
                const {body = {}} = result;

                store.getCode = {
                    code: body.otp || ''
                };

                return next();
            })
            .catch((error) => {
                store.getCode = {
                    isError: true,
                    errors: error,
                    trackId: trackId,
                    requestId: req.logID
                };

                PLog.warn()
                    .logId(req.logID)
                    .type('get_code, getCode')
                    .write(error);
                return next();
            });
    },
    rumCounterSetup,
    setTheme,
    function renderPage(req, res) {
        const lang = res.locals.language;

        res.render(`react.push-get-code.${lang}.jsx`);
    }
];

router.get('/', enter);
exports.router = router;
