const langSetup = require('./common/langSetup');
const apiSetup = require('./common/apiSetup');
const getMetrics = require('./common/getMetrics');
const createState = require('./common/createState');
const createAMState = require('./authv2/createAMState');
const validateAMParams = require('./authv2/validateAMParams');
const createAuthState = require('./authv2/createAuthState');
const userIsValid = require('./common/checkAuth/userIsValid');
const rumCounterSetup = require('./common/rumCounterSetup');
const setTheme = require('./authv2/setTheme');
const express = require('express');
const router = express.Router();

const enter = [
    apiSetup,
    langSetup,
    createState,
    validateAMParams,
    createAMState,
    createAuthState(),
    userIsValid,
    function(req, res, next) {
        const {store = {}} = res.locals;
        const {
            am: {isAm, finishErrorUrl}
        } = store;

        if (isAm && !res.locals.userIsValid) {
            req._controller.redirect(finishErrorUrl);
            return;
        }

        return next();
    },
    getMetrics({
        header: 'Попап логина в турбоаппе'
    }),
    rumCounterSetup,
    function(req, res, next) {
        res.locals.ua = {
            isTouch: true
        };

        return next();
    },
    setTheme,
    function renderPage(req, res) {
        const lang = res.locals.language;

        res.render(`react.push-turbo-app-login.${lang}.jsx`);
    }
];

router.get('/', enter);
exports.router = router;
