const langSetup = require('./common/langSetup');
const multiAuthAccountsSetup = require('./common/multiAuthAccountsSetup').getAccounts;
const apiSetup = require('./common/apiSetup');
const getUatraitsData = require('./common/getUatraitsData');
const writeStatbox = require('./common/writeStatbox');
const checkAuth = require('./common/checkAuth');
const createState = require('./registration/createRegistrationState');
const createSignUpState = require('./common/createSignUpState');
const createFormState = require('./common/createFormState');
const getMetrics = require('./common/getMetrics');
const rumCounterSetup = require('./common/rumCounterSetup');
const getRegistrationTrack = require('./registration/getRegistrationTrack');
const getYaExperimentsFlags = require('./common/getYaExperimentsFlags');

module.exports = [
    apiSetup,
    checkAuth,
    getUatraitsData,
    langSetup,
    multiAuthAccountsSetup,
    getRegistrationTrack,
    getYaExperimentsFlags,
    createState,
    createFormState,
    createSignUpState,
    writeStatbox({
        action: 'opened',
        mode: 'registration qr'
    }),
    getMetrics({header: 'Регистрация v2'}),
    rumCounterSetup,
    renderPage
];

function renderPage(req, res) {
    const lang = res.locals.language;

    res.render(`react.qr-registration.${lang}.jsx`);
}
