const langSetup = require('./common/langSetup');
const apiSetup = require('./common/apiSetup');
const getUatraitsData = require('./common/getUatraitsData');
const writeStatbox = require('./common/writeStatbox');
const createState = require('./registration/createRegistrationState');
const createSignUpState = require('./common/createSignUpState');
const createFormState = require('./common/createFormState');
const getYaExperimentsFlags = require('./common/getYaExperimentsFlags');
const getTrack = require('./common/getTrack');
const getMetrics = require('./common/getMetrics');
const rumCounterSetup = require('./common/rumCounterSetup');
const config = require('../configs/current');

module.exports = [
    apiSetup,
    (req, res, next) => {
        const lang = req.query.lang || req.nquery.lang;

        if (lang) {
            req._controller.setExplicitLanguage(lang);
        }

        return next();
    },
    getUatraitsData,
    langSetup,
    getYaExperimentsFlags,
    getTrack({type: 'register'}),
    createState,
    createFormState,
    createSignUpState,
    rumCounterSetup,
    writeStatbox({
        action: 'opened',
        mode: 'registration browser'
    }),
    getMetrics({}),
    (req, res, next) => {
        const storeDraft = res.locals.store || (res.locals.store = {});
        const resultStore = storeDraft.metrics || (storeDraft.metrics = {});

        Object.assign(resultStore, {
            header: `Регистрация ${(storeDraft.signup && storeDraft.signup.mode) || 'v2'}`
        });

        return next();
    },
    (req, res) => {
        const lang = res.locals.language;

        res.locals.ysaId = config.ysaIdMap.registration;

        res.render(`react.registration-browser.${lang}.jsx`);
    }
];
