const url = require('url');
const PLog = require('plog');
const apiSetup = require('./common/apiSetup');
const langSetup = require('./common/langSetup');
const LangSwitcherView = require('../blocks/layout/LangSwitcherView');
const getRegistrationTrack = require('./registration/getRegistrationTrack');
const getYaExperimentsFlags = require('./common/getYaExperimentsFlags');
const createSession = require('./registration/createSession');
const validateCSRF = require('./common/validateCSRF.js');
const writeStatbox = require('./registration/writeStatbox');
const getGenderSuggest = require('./common/getGenderSuggest');
const registerNewAccount = require('./common/registerAccount');
const getQuestionsAndCaptcha = require('./registration/prepareDataForRegistrationWithQuestions');
const setup = [
    langSetup,
    apiSetup,
    function(req, res, next) {
        res.locals.registrationName = 'lite';
        return next();
    },
    getRegistrationTrack,
    getYaExperimentsFlags,
    getQuestionsAndCaptcha
];
const returnBaseRegistrationState = require('./registration/returnBaseRegistrationState');
const returnExperimentFormObject = require('./registration/returnLiteExperimentFormObject');

exports.route = function(app) {
    const redirectToAuthLite = (requestObj) => {
        return requestObj._controller.redirectToLocalUrl(
            Object.assign({}, requestObj._controller.getUrl(), {
                pathname: 'auth/preregister'
            })
        );
    };

    app.get(/\/registration\/lite\/?.*/, function(req) {
        redirectToAuthLite(req);
    });
    app.get(/\/registration\/mlite\/?.*/, function(req) {
        redirectToAuthLite(req);
    });
    app.get(/\/registration-new\/lite\/?.*/, function(req) {
        redirectToAuthLite(req);
    });
};

exports.registerLiteEmail = [
    langSetup,
    apiSetup,
    function(req, res, next) {
        res.locals.regType = 'lite';
        return next();
    },
    getGenderSuggest,
    registerNewAccount,
    createSession
];

exports.registerExperimentLite = [
    langSetup,
    apiSetup,
    function(req, res, next) {
        res.locals.regType = 'lite-experiment';
        return next();
    },
    getGenderSuggest,
    // prepareFormData,
    registerNewAccount,
    createSession
];

exports.enter = [setup, createStore, setRegistrationMode, renderPage];

function renderPage(req, res) {
    const lang = res.locals.language;

    writeStatbox(req, res);
    res.render(`react.registration-lite.${lang}.jsx`);
}

function createStore(req, res, next) {
    // eslint-disable-line complexity
    // const isExperimentalLiteReg = Boolean(res.locals.experimentVersion);
    const registrationType = 'lite';
    const langSwitcher = new LangSwitcherView(req._controller);
    const locals = res.locals;
    const handlers = [req._controller.getUatraits(), langSwitcher._compile()];
    const retpath = (req.query && (req.query.url || req.query.retpath)) || null;
    const baseRegistrationState = returnBaseRegistrationState(req, res, locals.store);
    const registrationFormObj = returnExperimentFormObject(req, res);
    const finalRegistrationState = Object.assign({}, baseRegistrationState, {
        form: registrationFormObj,
        registrationType,
        registrationStep: 'start',
        registrationName: locals.registrationName,
        metrics: {
            header: 'Регистрация лайтов'
        },
        monitoring: {
            page: 'registration/lite'
        }
    });

    if (req.query.login) {
        registrationFormObj.values.email = req.query.login;
    }

    if (req.query.phone_number && registrationFormObj.values.phone !== undefined) {
        registrationFormObj.values.phone = req.query.phone_number;
    }

    if (retpath) {
        handlers.push(req.api.validateRetpath({retpath}));
    }
    locals.store = finalRegistrationState;

    Promise.all(handlers)
        .then(function(response) {
            const defaultRetpath = url.format(
                Object.assign({}, req._controller.getUrl(), {
                    pathname: 'profile',
                    search: null,
                    query: null
                })
            );
            const uatraits = response[0] || {};
            const langlist = (response[1] && response[1].langlist) || {};
            const validatedRetpath = response[2] || defaultRetpath;

            locals.store.settings.uatraits = uatraits;
            locals.store.footer.langlist = langlist;

            if (validatedRetpath.body && validatedRetpath.body.retpath) {
                locals.store.common.retpath = validatedRetpath.body.retpath;
            }

            if (req._controller.getRequestParam('from')) {
                locals.store.common.from = req._controller.getRequestParam('from');
            }
            return next();
        })
        .catch(function(err) {
            PLog.warn()
                .logId(req.logID)
                .type(`registration ${locals.registrationName}`)
                .write(err);
        });
}

function setRegistrationMode(req, res, next) {
    if (req.path.match(/\/registration\/mlite/)) {
        res.locals.store.form.canSwitchConfirmationMethod = false;
    }

    return next();
}

exports.sendConfirmationCode = [
    apiSetup,
    validateCSRF,
    function(req, res, next) {
        req.api.statboxLogger({
            track_id: res.locals.track_id || null,
            process_uuid: req.body.process_uuid || null,
            action: 'opened',
            mode: 'registration lite',
            host: req.hostname,
            pathname: req.path,
            referer: req.headers.referer || null,
            ip: req.headers['x-real-ip'],
            user_agent: req.headers['user-agent'],
            yandexuid: res._yandexuid && res._yandexuid.replace(/[^0-9]/g, ''),
            origin: (req.query && req.query.origin) || null,
            from: (req.query && req.query.from) || null,
            experimentsFlags: res.locals.experiments && res.locals.experiments.flagsString,
            experiment_boxes: res.locals.experiments && res.locals.experiments.boxes
        });
        return next();
    },
    function(req, res) {
        req.api
            .accountRegisterExperimentEmailSubmit(req.body)
            .then((result) => {
                res.json(result.body || result);
            })
            .catch((error) => {
                res.json({
                    status: 'error',
                    error
                });
            });
    }
];
