module.exports = (req, res, next) => {
    const origin = req.query.origin || '';
    const isOriginToRedirect = origin.includes('serp') || origin.includes('music');

    if (res.locals.experiments && isOriginToRedirect) {
        const experimentsFlags = res.locals.experiments && res.locals.experiments.flags;
        const flagToVersion = {
            'PASSP-20417_a': '1',
            'PASSP-20417_b': '2',
            'PASSP-20417_c': '3',
            'PASSP-20417_d': '4',
            'PASSP-20417_e': '5'
        };
        const isLiteExperiment = (flag) => Object.keys(flagToVersion).includes(flag);
        const liteExperimentFlag = experimentsFlags.filter((flag) => isLiteExperiment(flag));

        res.locals.experimentVersion = flagToVersion[liteExperimentFlag[0]];

        if (isLiteExperiment && req._controller.getUrl().pathname === '/registration') {
            return req._controller.redirectToLocalUrl({
                pathname: '/registration/lite',
                query: req.query
            });
        }
    }
    return next();
};
