const PLog = require('plog');
const url = require('url');
const config = require('../../configs/current');
const LangSwitcherView = require('../../blocks/layout/LangSwitcherView');
const isIntranet = process.env.INTRANET === 'intranet';
const isUnsupportedBro = require('../common/isUnsupportedBro');

module.exports = function createState(req, res, next) {
    // eslint-disable-line
    const langSwitcher = new LangSwitcherView(req._controller);
    const locals = res.locals;
    const {accounts = {}, userType = {}} = locals;
    const defaultAccount = accounts.defaultAccount || {};
    const avatarPaths = config.paths.avatar;
    const tld = req._controller.getTld();
    const yandexuid = res._yandexuid && res._yandexuid.replace(/[^0-9]/g, '');
    const {metricsUserType} = userType;
    const {blackbox: {connection_id: ci = ''} = {}} = req;

    let queryUid = '';

    if (req.query && req.query.uid) {
        queryUid = req.query.uid.replace(/[^0-9]/g, '');
    }

    locals.store = {
        settings: {
            host: url.format({
                protocol: req.headers['x-real-scheme'],
                hostname: req.hostname
            }),
            avatar: config.paths.avatar || {},
            links: isIntranet ? config.links.intranet : config.links[tld] || config.links.ru || {},
            help: config.paths.help || {},
            tld,
            staticPath: config.paths.static,
            language: locals.language,
            uatraits: locals.ua || {},
            env: {
                type: process.env.NODE_ENV,
                name: process.env.INTRANET
            },
            accountsUrl: config.paths.accountsUrl,
            version: config.version,
            metricsUserType
        },
        common: {
            uid: queryUid || defaultAccount.uid,
            process_uuid: res.locals.process_uuid,
            origin: (req.query && req.query.origin) || null,
            source: 'registration_avatar',
            login: defaultAccount.login,
            yandexuid,
            track_id: locals.track_id,
            retpath: locals.validRetpath,
            currentPage: req._controller.getUrl().href,
            defaultPage: url.format({
                pathname: '/profile',
                query: req.query
            }),
            experiments: res.locals.experiments || {
                flags: [],
                flagsString: '',
                boxes: '',
                encodedBoxes: ''
            }
        },
        avatar: {
            track_id: locals.avatarsTrack || null,
            default_300: avatarPaths.default_300,
            avatarSize_300: '',
            avatarPrev: '',
            isProcessing: false,
            isLoading: false,
            fileType: 'jpeg',
            compression: 0.6,
            isCropNotSupported: isUnsupportedBro(locals.ua),
            error: '',
            isOptionalStep: true,
            isUpdated: false
        },
        header: {
            accounts: (locals.accounts && locals.accounts.accounts) || [],
            defaultAccount,
            canAddMore: locals.accounts && locals.accounts['can-add-more'],
            ci
        },
        footer: {
            langlist: []
        },
        metrics: {
            header: 'Дозапрос аватара после регистрации'
        },
        monitoring: {
            page: 'registration avatar'
        },
        social: {
            brokerPath: config.paths.broker
        }
    };

    langSwitcher
        ._compile()
        .then(function(response) {
            const langlist = (response && response.langlist) || {};

            locals.store.footer.langlist = langlist;
        })
        .catch(function(error) {
            PLog.warn()
                .logId(req.logID)
                .type('profile.getdata, langSwitcher')
                .write(error);
        })
        .done(function() {
            delete locals.account;
            delete locals.accounts;
            return next();
        });
};
