const uuid = require('uuid');
const url = require('url');
const PLog = require('plog');
const config = require('../../configs/current');
const LangSwitcherView = require('../../blocks/layout/LangSwitcherView');
const isUnsupportedBro = require('../common/isUnsupportedBro');

const originsFromWebview = ['disk_app', 'music_app', 'telemost_app', 'telemost_chat_app', 'autofill'];
const originsFromWebviewWithSocialAuth = ['music_app'];

module.exports = function createStore(req, res, next) {
    // eslint-disable-line complexity
    const langSwitcher = new LangSwitcherView(req._controller);
    const locals = res.locals;
    const tld = req._controller.getTld();
    const yandexuid = res._yandexuid && res._yandexuid.replace(/[^0-9]/g, '');
    const handlers = [req._controller.getUatraits(), langSwitcher._compile()];
    const retpath = (req.query && (req.query.url || req.query.retpath)) || null;
    const authUrl = url.format({
        protocol: req.headers['x-real-scheme'],
        hostname: req.hostname,
        pathname: '/auth',
        query: req.query
    });
    const {regionId, countryId, captcha = {}, userType = {}} = locals;
    const origin = (req.query && req.query.origin) || null;
    const {version} = config;
    const {metricsUserType} = userType;
    const {ysa = {}} = config.paths;
    const {static: ysaPath} = ysa;
    const currentUrlObj = url.parse(url.format(req._controller.getUrl()), true);
    const {blackbox: {connection_id: ci = ''} = {}} = req;

    if (retpath) {
        handlers.push(req.api.validateRetpath({retpath}));
    }

    locals.store = Object.assign(
        {},
        {
            fetchingStatus: {
                isFetching: false
            },
            settings: {
                version,
                metricsUserType,
                ysaPath,
                process_uuid: res.locals.process_uuid,
                location: req.path,
                host: url.format({
                    protocol: req.headers['x-real-scheme'],
                    hostname: req.hostname
                }),
                embeddedauth: config.paths.embeddedauth || '',
                links:
                    process.env.INTRANET === 'intranet'
                        ? config.links.intranet
                        : config.links[tld] || config.links.com || {},
                help: config.paths.help || {},
                tld,
                staticPath: config.paths.static,
                language: locals.language,
                country: locals.country,
                uatraits: {},
                env: {
                    type: process.env.NODE_ENV,
                    name: process.env.INTRANET
                },
                formUrl: '/registration',
                tmxSession: uuid.v4(),
                authUrl,
                origin,
                avatar: config.paths.avatar || {},
                regionId,
                countryId,
                accountsUrl: config.paths.accountsUrl
            },
            common: {
                actionForRepeat: null,
                yandexuid,
                track_id: locals.track_id,
                retpath: null,
                currentPage: req._controller.getUrl().href,
                dev: config.dev,
                defaultPage: url.format({
                    pathname: '/registration',
                    query: req.query
                }),
                experiments: res.locals.experiments || {
                    flags: [],
                    flagsString: '',
                    boxes: '',
                    encodedBoxes: ''
                },
                magicQrUrl: config.paths.magicQrUrl,
                isYandex: locals.isYandex,
                isWebView: originsFromWebview.includes(origin),
                isWebViewWithSocialAuth: originsFromWebviewWithSocialAuth.includes(origin),
                debug: Boolean(req.query.debug || req.body.debug),
                familyChildishRegOriginUrl: url.parse(
                    url.format(
                        Object.assign({}, currentUrlObj, {
                            search: null,
                            pathname: '/profile/family',
                            query: Object.assign({}, currentUrlObj.query, {
                                origin: 'childish_reg'
                            })
                        })
                    )
                ).path
            },
            header: {
                accounts: (locals.accounts && locals.accounts.accounts) || [],
                defaultAccount: (locals.accounts || {}).defaultAccount || {},
                canAddMore: locals.accounts && locals.accounts['can-add-more'],
                ci
            },
            captcha: {
                loading: false,
                loadingAudio: false,
                playing: false,
                type: 'text',
                key: captcha.key,
                imageUrl: captcha.image_url,
                introSound: null,
                captchaSound: null
            },
            logins: {
                loginsList: [],
                isValidating: false,
                isFetching: false
            },
            isEulaConfirmPopupShow: false,
            additionalStep: {
                type: ''
            },
            footer: {
                langlist: []
            },
            metrics: {
                header: 'Регистрация v2',
                experiments: res.locals.experiments ? res.locals.experiments.encodedBoxes : ''
            },
            monitoring: {
                page: 'registration'
            },
            pageMessage: null
        },
        res.locals.store
    );

    Promise.all(handlers)
        .then(function(response) {
            const defaultRetpath = url.format(
                Object.assign({}, req._controller.getUrl(), {
                    pathname: 'profile',
                    search: null,
                    query: null
                })
            );
            const uatraits = response[0] || {};
            const langlist = (response[1] && response[1].langlist) || {};
            const validatedRetpath = response[2] || defaultRetpath;

            locals.store.settings.uatraits = uatraits;
            locals.store.footer.langlist = langlist;

            if ((uatraits.isMobile || uatraits.isTouch) && !uatraits.isTablet) {
                locals.store.metrics.header = 'Регистрация mobile';
            } else {
                locals.store.metrics.header = 'Регистрация v2';
            }

            if (validatedRetpath.body && validatedRetpath.body.retpath) {
                locals.store.common.retpath = validatedRetpath.body.retpath;
            } else {
                locals.store.common.retpath = defaultRetpath;
            }

            if (req._controller.getRequestParam('from')) {
                locals.store.common.from = req._controller.getRequestParam('from');
            }

            if (res.locals.experiments) {
                const experimentFlags = res.locals.experiments.flags;

                if (Array.isArray(experimentFlags)) {
                    if (!isUnsupportedBro(uatraits)) {
                        const regType = experimentFlags.includes('back_qr_promo_reg_on') ? 'qr' : 'avatar';

                        locals.store.additionalStep.type = regType;
                        locals.store.additionalStep.path = url.format({
                            protocol: req.headers['x-real-scheme'],
                            hostname: req.hostname,
                            pathname: `/registration/${regType}`,
                            query: req.query
                        });
                    }
                }
            }

            locals.store.captcha.ocr = true;

            return next();
        })
        .catch(function(err) {
            PLog.warn()
                .logId(req.logID)
                .type('registration.v2')
                .write(err);
        });
};
