const RegController = require('../../lib/controller/RegistrationController');
const PLog = require('plog');

module.exports = function createSession(req, res, next) {
    const registrationController = new RegController(req, res, req.logID);
    const isAjax = req.headers['x-requested-with'] === 'XMLHttpRequest';
    const {body = {}} = req;
    const {retpath} = body;

    return registrationController
        .createSession({retpath}) // TODO replace outdated API /1/session/ to /1/bundle/session/
        .then((response = {}) => {
            const {body = {}} = response;
            const {retpath: responseRetpath} = body;

            if (isAjax) {
                return res.json({status: 'ok', retpath: responseRetpath});
            }

            return registrationController.redirectToFinish(res.locals.track_id);
        })
        .catch((error) => {
            const sessionError = [{field: 'global', code: 'sessionidoverflow'}];

            PLog.warn()
                .logId(req.logID)
                .type('registration.v2')
                .write('createSession ', error);

            if (isAjax) {
                return res.json({status: 'error', error: sessionError});
            }

            res.locals.formErrors = sessionError;
            return next();
        });
};
