const BillingInternalApi = require('../../lib/api/billingInternal');
const {SERVICE_ALIASES} = require('../../lib/tvm');

module.exports = function getPlusPromocode(req, res, next) {
    const {experimentsList = {}} = res.locals.store || {};
    const CODE_PROTOTYPE = 'PASSPORTEXPERIMENT29971';
    const serviceTicket = req.serviceTickets && req.serviceTickets[SERVICE_ALIASES.MEDIABILLING];

    if (!experimentsList.isPlusPromo) {
        return next();
    }

    return new BillingInternalApi(req.logID, serviceTicket)
        .getPromoCode(CODE_PROTOTYPE)
        .then((response = {}) => {
            const {result = {}} = response;

            if (result.code) {
                experimentsList.plusPromoCode = result.code;
            }

            return next();
        })
        .catch(() => {
            return next();
        });
};
