const apiSetup = require('../common/apiSetup');
const PLog = require('plog');

module.exports = [
    apiSetup,
    (req, res) => {
        req._controller
            .getCsrfToken()
            .then((token) => {
                res.json({updatedCSRF: token});
            })
            .catch((err) => {
                PLog.warn()
                    .logId(req.logID)
                    .type('getUpdatedCsrf')
                    .write(err);
            });
    }
];
