module.exports = function handlePhoneCallExperiment(experimentFlags, lang) {
    const experimentInfo = {};
    const isForcePhoneCallConfirmationExperiment =
        experimentFlags.includes('passp-20231-forced-zvonok') && lang === 'ru';
    const isDiscardCallConfirmation =
        experimentFlags.includes('passp-20231-hangup') || experimentFlags.includes('passp-20231-hangup-touch');
    const updateExperimentInfoForCall = () => {
        experimentInfo.isForcePhoneCallConfirmation = true;
        experimentInfo.isPhoneCallConfirmationAvailable = true;
        experimentInfo.isDiscardCallConfirmation = true;
    };

    if (isForcePhoneCallConfirmationExperiment) {
        experimentInfo.isForcePhoneCallConfirmation = true;
    }

    if (isForcePhoneCallConfirmationExperiment) {
        experimentInfo.isPhoneCallConfirmationAvailable = true;
    }

    if (isDiscardCallConfirmation) {
        updateExperimentInfoForCall();
    }

    if (experimentFlags.includes('passp-24626-hangup-touch-recall-on')) {
        updateExperimentInfoForCall();
        experimentInfo.isMobileRecallBtnRemoved = true;
    }

    if (experimentFlags.includes('passp-24626-hangup-touch-sms-off')) {
        updateExperimentInfoForCall();
        experimentInfo.isMobileCallConfirmationOnly = true;
    }

    return experimentInfo;
};
