const RegController = require('../../lib/controller/RegistrationController');
const url = require('url');
const PLog = require('plog');

module.exports = function onAccountCreated(req, res, next) {
    if (req.body.type && req.body.type === 'market-partner') {
        const controller = new RegController(req, res, req.logID);
        const trackId = controller.getRequestParam('track_id');

        return controller
            .readTrack(trackId)
            .then(function(trackData) {
                controller.deleteTrack();

                const currentUrl = controller.getUrl();

                let retpath = trackData.retpath;

                if (!retpath) {
                    retpath = url.format({
                        protocol: currentUrl.protocol,
                        hostname: currentUrl.hostname,
                        pathname: 'passport',
                        query: {
                            mode: 'passport'
                        }
                    });
                }

                res.json({status: 'ok', target: retpath});
            })
            .catch(function(error) {
                res.json({status: 'error', error});
                PLog.warn()
                    .logId(req.logID)
                    .type('registration.v2')
                    .write('readTrack', JSON.stringify(error));
            });
    }

    next();
};
