module.exports = (req, res, next) => {
    const isRedirectShouldSkipped = req.query.skipLite;

    if (isRedirectShouldSkipped) {
        return next();
    }

    const origin = req.query.origin;
    const experimentFlags = (res.locals.experiments && res.locals.experiments.flags) || [];
    const redirectedOrigins = ['courier', 'courier_international', 'beru', 'contest', 'praktikum', 'practicum'];

    if (/^market/.test(origin)) {
        redirectedOrigins.push(origin);
    }

    if (experimentFlags.includes('PASSP-21745_exp')) {
        redirectedOrigins.push('afisha');
    }

    if (redirectedOrigins.includes(origin)) {
        return req._controller.redirectToLocalUrl({
            pathname: '/registration/lite',
            query: req.query
        });
    }

    return next();
};
