const isUnsupportedBro = require('../common/isUnsupportedBro');
const isNeoPhonishRegisterAvailable = require('../common/isNeoPhonishRegisterAvailable');
const isRegisterInDaHouseAvailable = require('../common/isRegisterInDaHouseAvailable');

module.exports = (req, res, next) => {
    const {origin} = req.query;
    const {experiments = {}, ua = {}} = res.locals;
    const {flags = []} = experiments;
    const forcedByNeoPhonish = isNeoPhonishRegisterAvailable(flags, origin);
    const forcedByOrigin = isRegisterInDaHouseAvailable(origin);

    if (
        !isUnsupportedBro(ua) &&
        (flags.includes('register-with-suggest-to-restore-by-phone-in-da-house') ||
            forcedByOrigin ||
            forcedByNeoPhonish)
    ) {
        return req._controller.redirectToLocalUrl({
            pathname: '/auth/reg',
            query: req.query
        });
    }

    return next();
};
