const config = require('../../configs/current/index');
const url = require('url');
const uuid = require('uuid');

module.exports = function(req, res, currentState) {
    const authUrl = url.format({
        protocol: req.headers['x-real-scheme'],
        hostname: req.hostname,
        pathname: '/auth',
        query: req.query
    });
    const yandexuid = res._yandexuid && res._yandexuid.replace(/[^0-9]/g, '');
    const tld = req._controller.getTld() || 'ru';

    return Object.assign({}, currentState, {
        fetchingStatus: {
            isFetching: false
        },
        settings: {
            location: req.path,
            host: url.format({
                protocol: req.headers['x-real-scheme'],
                hostname: req.hostname
            }),
            embeddedauth: config.paths.embeddedauth || '',
            links:
                process.env.INTRANET === 'intranet'
                    ? config.links.intranet
                    : config.links[tld] || config.links.com || {},
            help: config.paths.help || {},
            tld,
            staticPath: config.paths.static,
            language: res.locals.language,
            uatraits: {},
            env: {
                type: process.env.NODE_ENV,
                name: process.env.INTRANET
            },
            formUrl: '/registration',
            tmxSession: uuid.v4(),
            authUrl,
            accountsUrl: config.paths.accountsUrl
        },
        common: {
            actionForRepeat: null,
            yandexuid,
            track_id: res.locals.track_id,
            retpath: null,
            query: req.query,
            currentPage: req._controller.getUrl().href,
            experiments: res.locals.experiments || {
                flags: [],
                flagsString: ''
            }
        },
        registrationErrors: {
            status: 'ok',
            code: '',
            text: ''
        },
        footer: {
            langlist: []
        }
    });
};
