module.exports = function(req, res) {
    const setQuestionsList = () => {
        const questions = res.locals.questions;
        const areQuestionsAvailable = questions && Array.isArray(questions) && questions.length > 1;

        if (areQuestionsAvailable) {
            return questions.slice(1).map((question, index) => ({
                id: `q${index}`,
                val: question.id,
                text: question.value
            }));
        }
        return [];
    };
    const formErrors = res.locals.formErrors || [];
    const captchaErrors = res.locals.captchaErrors || [];
    const questionList = setQuestionsList();
    const haveQuestionsToBeSet = questionList.length > 0;

    return {
        activeField: '',
        validation: {
            method: 'phone',
            humanConfirmationDone: false
        },
        isEulaShowedInPopup: true,
        isEulaCheckedByDefault: false,
        formErrors,
        captchaErrors,
        states: {
            firstname: '',
            lastname: '',
            login: '',
            email: '',
            emailCode: '',
            password: '',
            password_confirm: '',
            hint_question_id: haveQuestionsToBeSet ? 'valid' : '',
            hint_question: haveQuestionsToBeSet ? 'valid' : '',
            hint_question_custom: 'valid',
            hint_answer: '',
            captcha: '',
            phone: '',
            phoneCode: '',
            phoneCodeStatus: '',
            emailCodeStatus: ''
        },
        values: {
            firstname: '',
            lastname: '',
            surname: '',
            login: '',
            email: '',
            emailCode: '',
            password: '',
            password_confirm: '',
            hint_question_id: haveQuestionsToBeSet ? questionList[0].val : '',
            hint_question: haveQuestionsToBeSet ? questionList[0].text : '',
            hint_question_custom: '',
            hint_answer: '',
            captcha: '',
            phone: '',
            phoneCode: ''
        },
        errors: {
            active: '',
            firstname: {
                code: '',
                text: ''
            },
            lastname: {
                code: '',
                text: ''
            },
            login: {
                code: '',
                text: ''
            },
            email: {
                code: '',
                text: ''
            },
            emailCode: {
                code: '',
                text: ''
            },
            password: {
                code: '',
                text: ''
            },
            password_confirm: {
                code: '',
                text: ''
            },
            hint_question_id: {
                code: '',
                text: ''
            },
            hint_question: {
                code: '',
                text: ''
            },
            hint_question_custom: {
                code: '',
                text: ''
            },
            hint_answer: {
                code: '',
                text: ''
            },
            captcha: {
                code: '',
                text: ''
            },
            phone: {
                code: '',
                text: ''
            },
            phoneCode: {
                code: '',
                text: ''
            },
            phoneCodeStatus: ''
        },
        humanConfirmation: {
            questionList,
            isFetching: false
        },
        canSwitchConfirmationMethod: false
    };
};
