module.exports = function(req, res) {
    const formErrors = res.locals.formErrors || [];
    const requiredFields = ['email', 'firstname', 'lastname', 'password', 'password_confirm'];
    const currentFields = extendWithRequiredFields(requiredFields);
    const currentErrorFields = extendWithRequiredFields(requiredFields, 'error');

    return {
        activeField: '',
        validation: {
            method: 'email',
            humanConfirmationDone: false
        },
        formErrors,
        states: Object.assign({}, currentFields, {
            emailCode: '',
            emailCodeStatus: '',
            captcha: ''
        }),
        values: Object.assign({}, currentFields, {
            surname: '',
            emailCode: '',
            captcha: ''
        }),
        errors: Object.assign({}, currentErrorFields, {
            active: '',
            emailCode: {
                code: '',
                text: ''
            },
            captcha: {
                code: '',
                text: ''
            }
        })
    };
};

function extendWithRequiredFields(version, type) {
    const objValue = type && type === 'error' ? {code: '', text: ''} : '';

    return version.reduce((obj = {}, item) => {
        obj[item] = objValue;
        return obj;
    }, {});
}
