const ORIGINS_BLOCK_LIST = ['serp_touch_auth_fonishnos'];
const ORIGINS_LIST = ['serp', 'video', 'browser', 'collections', 'znatoki_unauth_theme_onboarding', 'hostroot', 'home'];

module.exports = function setRegExperiments(req, res, next) {
    const origin = req.query && req.query.origin;
    const experiments = res.locals.experiments && res.locals.experiments.flags;
    const localsStore = res.locals.store;

    if (experiments && experiments.length !== 0) {
        const experimentsList = {};

        if (experiments.includes('reg_button_always_on_exp')) {
            experimentsList.isNoPhoneBtnShowed = true;
        }

        if (origin && typeof origin === 'string') {
            // PASSP-24768
            const isOriginForExp = ORIGINS_LIST.some((item) => origin.startsWith(item));
            const isOriginFromBlockList = ORIGINS_BLOCK_LIST.includes(origin);
            const isPlusOrigin = ['hostroot', 'home'].some((item) => origin.startsWith(item));
            const socialProviders = localsStore.social && localsStore.social.providers;

            if (isOriginForExp && socialProviders && !isOriginFromBlockList && !isPlusOrigin) {
                const providersAvailable = socialProviders.map((provider) => provider.id);
                const getActualProvidersIDs = (ids) => ids.filter((id) => providersAvailable.includes(id));

                experimentsList.isSocialBtnsShowed = true;
                experimentsList.providersID = getActualProvidersIDs([1, 2, 5]);
            }

            if (
                res.locals.language === 'ru' &&
                req._controller.getTld() === 'ru' &&
                res.locals.countryId === 225 &&
                experiments.includes('reg-promo-plus-exp') &&
                isPlusOrigin
            ) {
                experimentsList.isPlusPromo = true;
            }
        }

        localsStore.experimentsList = Object.assign({}, experimentsList);
    }

    return next();
};
