module.exports = function(req, res) {
    req.api.statboxLogger({
        track_id: res.locals.track_id || null,
        process_uuid: req.query.process_uuid || null,
        action: 'opened',
        mode: `registration ${res.locals.registrationName}`,
        host: req.hostname,
        pathname: req.path,
        referer: req.headers.referer || null,
        ip: req.headers['x-real-ip'],
        user_agent: req.headers['user-agent'],
        yandexuid: res._yandexuid && res._yandexuid.replace(/[^0-9]/g, ''),
        origin: (req.query && req.query.origin) || null,
        from: (req.query && req.query.from) || null,
        experimentsFlags: res.locals.experiments && res.locals.experiments.flagsString,
        experiment_boxes: res.locals.experiments && res.locals.experiments.boxes
    });
};
