var apiSetup = require('./common/apiSetup');
var createCSRFValidator = require('./common/createCSRFValidator');
var PForm = require('pform');
var config = require('../configs/current');
var locs = require('../loc/auth.json');
var _ = require('lodash');
var when = require('when');
var url = require('url');

function setShortModePass(req, res, next) {
    res.locals.mode = 'access_to_change_password';
    next();
}

exports.route = function(app) {
    app
        // .all('/restoration/semi_auto', this.restore.enter)
        // .get('/restoration/semi_auto/submit', this.restore.enter)
        // .post('/restoration/semi_auto/submit', this.restore.submit)
        // .get('/restoration/semi_auto/finish', this.restore.finish)

        .all('/restoration/semi_auto_pass', setShortModePass, this.restore.enter)
        .get('/restoration/semi_auto_pass/submit', setShortModePass, this.restore.enter)
        .post('/restoration/semi_auto_pass/submit', setShortModePass, this.restore.submit)
        .post('/restoration/semi_auto_pass/submit', setShortModePass, this.restore.enterpassword)
        .post('/restoration/semi_auto_pass/submitpassword', setShortModePass, this.restore.submitpassword)
        .get('/restoration/semi_auto_pass/submitpassword', function(req, res) {
            // на эту страницу нельзя приходить гетом
            return res.redirect('/auth');
        })
        .get('/restoration/semi_auto_pass/finish', setShortModePass, this.restore.finishpassword)

        .all('/for/:pdd_domain/restoration/semi_auto_pass', setShortModePass, this.restore.enter)
        .get('/for/:pdd_domain/restoration/semi_auto_pass/submit', setShortModePass, this.restore.enter)
        .post('/for/:pdd_domain/restoration/semi_auto_pass/submit', setShortModePass, this.restore.submit)
        .post('/for/:pdd_domain/restoration/semi_auto_pass/submit', setShortModePass, this.restore.enterpassword)
        .post(
            '/for/:pdd_domain/restoration/semi_auto_pass/submitpassword',
            setShortModePass,
            this.restore.submitpassword
        )
        .get('/for/:pdd_domain/restoration/semi_auto_pass/submitpassword', function(req, res) {
            // на эту страницу нельзя приходить гетом
            return res.redirect('/auth');
        })
        .get('/for/:pdd_domain/restoration/semi_auto_pass/finish', setShortModePass, this.restore.finishpassword);
};

var setup = [
    require('cookie-session')({
        name: 'pf',
        keys: require('keygrip')(['bihiejkgeghofcpabilfdbagjjebpnkj'], 'sha256')
    }),
    require('connect-flash')(),
    function(req, res, next) {
        if (/finish/.test(req.path)) {
            return next();
        }

        var trackId = req.body['track_id'] || req.query['track_id'];

        if (!trackId) {
            if (res.locals.mode && res.locals.mode === 'access_to_change_password') {
                res.redirect('/auth');
                return;
            }

            // без трека отправляем на рестор
            res.redirect('/passport?mode=restore');
            return;
        }

        res.locals.track_id = trackId;
        next();
    },
    apiSetup,
    function(req, res, next) {
        new (require('../lib/controller'))(req, res, req.logID)
            .getLanguage()
            .then(function(lang) {
                res.locals.language = lang;
            })
            .catch(function(err) {
                res.locals.language = 'ru';

                require('plog')
                    .warn()
                    .logId(req.logID)
                    .type('restore fio')
                    .write(err);
            })
            .done(function() {
                return next();
            });
    },
    function(req, res, next) {
        var logoutRetpath = encodeURIComponent(
            url.format({
                protocol: req.headers['x-real-scheme'],
                host: req.hostname,
                pathname: req.path,
                query: {
                    track_id: res.locals.track_id
                }
            })
        );

        _.assign(res.locals, {
            consumer: config.defaults.qs.consumer,
            loc: locs[res.locals.language],
            logoutRetpath,
            isPdd: !config.multiauth && req.params.pdd_domain ? true : false
        });

        if (res.locals.isPdd) {
            res.locals.pddDomain = req.params.pdd_domain;
        }

        next();
    }
];

var helper = {
    errorIds: {
        'account.disabled': 'ErrorsTexts.badlog_blocked',
        'account.not_found': 'ErrorsTexts.deleted',
        'account.disabled_on_deletion': 'ErrorsTexts.deleted',
        'compare.not_matched': 'import.account_not_found',
        'backend.historydb_api_failed': 'ErrorsTexts.internal',
        'backend.oauth_failed': 'ErrorsTexts.internal',
        password_change_forbidden: 'pdd_password_change_forbidden',
        'account.without_password': 'without_password',
        complete_social: 'social_without_password',
        complete_pdd: 'request_pdd_admin',
        internal: 'ErrorsTexts.internal'
    },

    mendIds: {
        'account.disabled': 'disabled',
        'account.not_found': 'deleted',
        'account.disabled_on_deletion': 'deleted',
        internal: 'crap',
        'track.not_found': 'crap',
        'compare.not_matched': 'account_not_found'
    },

    internalErrIds: ['exception.unhandled', 'track.invalid_state', 'track.not_found'],

    skipErrIds: [
        'birthday.invalid',
        'birthday.empty',
        'firstname.empty',
        'lastname.empty',
        'password.empty',
        'password.likelogin',
        'password.tooshort',
        'password.toolong',
        'password.weak',
        'password.prohibitedsymbols',
        'password.likeoldpassword',
        'password.foundinhistory',
        'password.found_in_history',
        'password.likephonenumber',
        'password_auth_date.empty',
        'contact_email.empty',
        'registration_city.empty',
        'registration_country.empty',
        'registration_date.invalid',
        'registration_date.empty',
        'eula_accepted.empty',
        'contact_email.empty',
        'contact_email.invalid',
        'contact_email.from_same_account',
        'social_accounts.invalid',
        'email_blacklist.invalid',
        'email_folders.invalid',
        'email_whitelist.invalid',
        'outbound_emails.invalid',
        'question.empty',
        'photo_file.file_too_large',
        'password.equals_previous',
        'captcha.required'
    ],

    fieldsNameMap: {
        contact_email: 'feedback-email',
        social_accounts: 'social_profiles',
        email_blacklist: 'blacklist-mail',
        email_whitelist: 'whitelist-mail',
        outbound_emails: 'sender-mail',
        email_folders: 'folders-mail',
        question: 'questions',
        photo_file: 'attach'
    },

    fieldsCodeMap: {
        equals_previous: 'likeoldpassword',
        found_in_history: 'foundinhistory'
    },

    stateMessage: {
        password_change_forbidden: 'pdd_password_change_forbidden',
        complete_social: 'social_without_password',
        complete_pdd: 'request_pdd_admin',
        rate_limit_exceeded: 'restore_fio_limit_exceeded',
        complete_autoregistered: 'restore_complete_autoregistered',
        domain_not_served: 'restore_domain_not_served'
    },

    activateFieldError(code, form) {
        if (typeof code !== 'string') {
            return;
        }

        var _code = code.split('.');
        var fieldName = helper.fieldsNameMap[_code[0]] || _code[0];
        var field = form.getField(fieldName);

        if (field) {
            var codeName = helper.fieldsCodeMap[_code[1]] || _code[1];
            var err = field.getErrorByCode(codeName);

            if (err) {
                err.setActive();
            }
        }
    },

    normalize(str) {
        var re = /\s+/;

        return (
            (str &&
                String(str)
                    .split(re)
                    .join(' ')
                    .trim()) ||
            str
        );
    },

    normalizePhone(number) {
        return number.replace(/\D/g, '');
    },

    getErrorsTexts(lang) {
        return locs[lang]['Errors'];
    },

    getMendTexts(lang) {
        return locs[lang]['Mend'];
    },

    formatDate(data, prefix) {
        var year = data[`${prefix}year`] || '0000';
        var month = data[`${prefix}month`] === 13 ? '00' : data[`${prefix}month`] || '00';
        var day = data[`${prefix}day`] || '00';
        var date;

        if ((year || day) && month !== 13) {
            date = [year, month, day.trim().length === 1 && day < 10 ? `0${day.trim()}` : day].join('-');
        }

        return date;
    },

    formatAddress(data) {
        var that = this;
        var addr = {};
        var optionalFields = ['suite'];
        var requiredFields = ['country', 'city', 'street', 'building'];

        requiredFields.forEach(function(item) {
            if (data[item]) {
                addr[item] = that.normalize(data[item]);
            }
        });

        optionalFields.forEach(function(item) {
            if (data[item]) {
                addr[item] = that.normalize(data[item]);
            }
        });

        return addr[requiredFields[0]] ? JSON.stringify([addr]) : null;
    },

    formatFieldsValues: [
        function(req, res, next) {
            var files = req.files || {};
            var file = files[Object.keys(files)[0]];

            res.formFiles = {
                attach: file
            };
            return next();
        },
        function(req, res, next) {
            var resultData = {};
            var addr = helper.formatAddress(req.body);

            if (addr) {
                resultData.address = addr;
            }

            resultData.birthday = helper.formatDate(req.body, 'b');
            resultData.registration_date = helper.formatDate(req.body, 'r');

            if (!req.body['remember_last-passwords']) {
                resultData.last_success_auth_date = '';
                if (req.body['last-passwords']) {
                    resultData.last_success_auth_date = helper.formatDate(req.body, 'last-passwords_auth_');
                }
            }

            var maybeArray = [
                'phones',
                'additional-email',
                'social_profiles',
                'folders-mail',
                'sender-mail',
                'collector-mail',
                'whitelist-mail',
                'blacklist-mail'
            ];

            maybeArray.forEach(function(item) {
                if (req.body[item]) {
                    var normalizedValue = '';
                    var valuesArr = [];

                    [].concat(req.body[item]).forEach(function(val) {
                        if (item === 'phones') {
                            normalizedValue = helper.normalizePhone(val);
                        } else {
                            normalizedValue = helper.normalize(val);
                        }

                        if (normalizedValue) {
                            valuesArr.push(encodeURIComponent(normalizedValue));
                        }
                    });

                    resultData[item] = valuesArr.join();
                }
            });

            res.formData = _.extend({}, req.body, resultData, res.formFiles);

            next();
        }
    ],

    parseState(res, state) {
        res.locals.errorState = '';
        var messages = [];
        var locErr = helper.getErrorsTexts(res.locals.language);

        [].concat(helper.stateMessage[state]).forEach(function(err) {
            messages.push(locErr[err]);
        });
        res.locals.errorState = messages.join(' ');
    }
};

var FieldRegistrationCountry = require('../blocks/control/restore/registration-country/registration-country.field');
var FieldRegistrationCity = require('../blocks/control/restore/registration-city/registration-city.field');
var FieldRegistrationDate = require('../blocks/control/restore/registration-date/registration-date.field');
var FieldFeedbackEmail = require('../blocks/control/restore/feedback-email/feedback-email.field');
var FieldAttach = require('../blocks/control/restore/attach/attach.field');
var FieldAdditionalEmail = require('../blocks/control/restore/additional-email/additional-email.field');
var FieldAddress = require('../blocks/control/restore/address/address.field');
var FieldCountry = require('../blocks/control/restore/address/country/country.field');
var FieldCity = require('../blocks/control/restore/address/city/city.field');
var FieldStreet = require('../blocks/control/restore/address/street/street.field');
var FieldBuilding = require('../blocks/control/restore/address/building/building.field');
var FieldSuite = require('../blocks/control/restore/address/suite/suite.field');
var FieldPhones = require('../blocks/control/restore/phones/phones.field');
var FieldQuestions = require('../blocks/control/restore/questions/questions.field');
var FieldSocialProfiles = require('../blocks/control/restore/social-profiles/social-profiles.field');
var FieldLastPasswords = require('../blocks/control/restore/last-passwords/last-passwords.field');
var FieldUserEnabled = require('../blocks/control/restore/user-enabled/user-enabled.field');
var FieldContactReason = require('../blocks/control/restore/contact-reason/contact-reason.field');
var FieldFirstname = require('../blocks/control/firstname/firstname.field');
var FieldLastname = require('../blocks/control/lastname/lastname.field');
var FieldBirthday = require('../blocks/control/birthday/birthday.field');
var FieldEulaConfidential = require('../blocks/control/checkbox/eula-confidential/eula-confidential.field.js');
var FieldFoldersMail = require('../blocks/control/restore/mail/folders-mail/folders-mail.field');
var FieldSenderMail = require('../blocks/control/restore/mail/sender-mail/sender-mail.field');
var FieldCollectorMail = require('../blocks/control/restore/mail/collector-mail/collector-mail.field');
var FieldWhitelistMail = require('../blocks/control/restore/mail/whitelist-mail/whitelist-mail.field');
var FieldBlacklistMail = require('../blocks/control/restore/mail/blacklist-mail/blacklist-mail.field');
var FieldPassword = require('../blocks/control/password/password.field');
var FieldPasswordConfirm = require('../blocks/control/password-confirm/password-confirm.field');
var FieldCaptcha = require('../blocks/control/captcha/captcha.field');
var FieldPhoneConfirm = require('../blocks/control/phone-confirm/phone-confirm.field');

var constructor = {
    getForm: {
        base() {
            return new PForm(
                // ресторовые обязательные контролы
                new FieldRegistrationCountry().setRequired(),
                new FieldRegistrationCity().setRequired(),
                new FieldRegistrationDate().setRequired(),
                new FieldFeedbackEmail().setRequired(),
                new FieldAttach(),

                // ресторовые необязательные контролы
                new FieldAdditionalEmail().setOption('maxFieldsCount', 5),
                new FieldAddress(),
                new FieldCountry().setOption('grid', 'two'),
                new FieldCity().setOption('grid', 'two'),
                new FieldStreet().setOption('grid', 'two'),
                new FieldBuilding().setOption('grid', 'six'),
                new FieldSuite().setOption('grid', 'six'),
                new FieldPhones().setOption('maxFieldsCount', 5),
                new FieldQuestions(),
                new FieldSocialProfiles().setOption('maxFieldsCount', 5),
                new FieldLastPasswords(),
                new FieldUserEnabled(),
                new FieldContactReason(),

                // общие обязательные контролы
                new FieldFirstname().setRequired(),
                new FieldLastname().setRequired(),
                new FieldBirthday().setRequired(),
                new FieldEulaConfidential(),

                // почтовые контролы
                new FieldFoldersMail().setOption('maxFieldsCount', 5),
                new FieldSenderMail().setOption('maxFieldsCount', 5),
                new FieldCollectorMail().setOption('maxFieldsCount', 5),
                new FieldWhitelistMail().setOption('maxFieldsCount', 5),
                new FieldBlacklistMail().setOption('maxFieldsCount', 5)
            );
        },

        shortform() {
            return new PForm(
                new FieldRegistrationCountry().setRequired(),
                new FieldRegistrationCity().setRequired(),
                new FieldRegistrationDate().setRequired(),
                new FieldFirstname().setRequired(),
                new FieldLastname().setRequired(),
                new FieldBirthday().setRequired(),
                new FieldEulaConfidential()
            );
        },

        changepass() {
            return new PForm(
                new FieldPassword().setRequired(),
                new FieldPasswordConfirm().setRequired(),
                new FieldCaptcha().setRequired().setOption('asyncCheck', true),
                new FieldPhoneConfirm().setRequired().setOption('prevCheckCaptcha', true)
            );
        },

        changepassPdd() {
            return new PForm(
                new FieldPassword().setRequired(),
                new FieldPasswordConfirm().setRequired(),
                new FieldCaptcha().setRequired().setOption('asyncCheck', true)
            );
        }
    },

    restoreProcess: {
        base(req, res) {
            res.locals.formAction = '/restoration/semi_auto/submit';
            res.locals.hasAttach = true;

            var form = constructor.getForm['base']().setApi(req.api);
            var compilePromise = when.resolve();
            const experimentFlags = res.locals.experiments && res.locals.experiments.flagsString;
            const experimentBoxes = res.locals.experiments && res.locals.experiments.boxes;

            if (res.locals.state === 'enter') {
                // write to statbox
                compilePromise = compilePromise.then(function() {
                    return req.api.statboxLogger({
                        ignoreMissedTrack: true,
                        action: 'opened',
                        mode: 'restore_semi_auto',
                        track_id: res.locals.track_id || null,
                        process_uuid: req.query.process_uuid || null,
                        ip: req.headers['x-real-ip'],
                        host: req.hostname,
                        user_agent: req.headers['user-agent'],
                        yandexuid: req.cookies.yandexuid,
                        experiment_flags: experimentFlags,
                        experiment_boxes: experimentBoxes
                    });
                });
            }

            if (res.locals.state !== 'finish') {
                // get user questions
                compilePromise = compilePromise
                    .then(function() {
                        return req.api.restoreSemiAutoFromData();
                    })
                    .then(
                        function(result) {
                            if (result.body && result.body.state) {
                                return when.reject(result.body.state);
                            }

                            if (result.body && result.body.questions.length) {
                                result.body.questions.unshift({
                                    id: -1,
                                    text: locs[res.locals.language]['common'].empty
                                });
                                form.getField('questions').setQuestions(result.body.questions);
                            }
                        },
                        function(error) {
                            return constructor.errorProcess(error, res);
                        }
                    )
                    .catch(function(state) {
                        helper.parseState(res, state);
                    });
            }

            if (req.method === 'POST' && res.locals.state === 'submit') {
                // commit form data
                compilePromise = compilePromise
                    .then(function() {
                        return req.api.restoreSemiAutoCommit(res.formData);
                    })
                    .then(
                        function(result) {
                            if (result.body && result.body.state) {
                                return when.reject(result.body.state);
                            }

                            if (result.body.status === 'ok') {
                                res.redirect('/restoration/semi_auto/finish');
                            }
                        },
                        function(error) {
                            if (error) {
                                [].concat(error).forEach(function(code) {
                                    helper.activateFieldError(code, form);
                                });
                            }

                            return constructor.errorProcess(error, res);
                        }
                    );
            }

            if (res.locals.state !== 'finish') {
                // validate and compile form
                compilePromise = compilePromise
                    .then(function() {
                        return form.validate(req.body);
                    })
                    .then(function() {
                        return form.compile(res.locals.language);
                    })
                    .then(function(compiled) {
                        res.locals.form = {
                            control: compiled
                        };
                    });
            }

            compilePromise
                .catch(function(state) {
                    helper.parseState(res, state);
                })
                .then(function() {
                    res.render(`restore.fio.${res.locals.language}.js`);
                });
        },

        shortform(req, res, next) {
            res.locals.formAction = res.locals.isPdd
                ? `/for/${res.locals.pddDomain}/restoration/semi_auto_pass/submit`
                : '/restoration/semi_auto_pass/submit';

            var locErr = helper.getErrorsTexts(res.locals.language);
            var form = constructor.getForm['shortform']().setApi(req.api);
            // eslint-disable-next-line no-unused-vars
            var compilePromise = when.resolve();
            const experimentFlags = res.locals.experiments && res.locals.experiments.flagsString;
            const experimentBoxes = res.locals.experiments && res.locals.experiments.boxes;

            if (res.locals.state === 'enter') {
                // write to statbox
                compilePromise = compilePromise.then(function() {
                    return req.api.statboxLogger({
                        ignoreMissedTrack: true,
                        action: 'opened',
                        mode: 'restore_semi_auto_access_to_change_password',
                        track_id: res.locals.track_id || null,
                        process_uuid: req.query.process_uuid || null,
                        ip: req.headers['x-real-ip'],
                        host: req.hostname,
                        user_agent: req.headers['user-agent'],
                        yandexuid: req.cookies.yandexuid,
                        experiment_flags: experimentFlags,
                        experiment_boxes: experimentBoxes
                    });
                });
            }

            if (req.method === 'POST' && res.locals.state === 'submit') {
                // commit form data
                compilePromise = compilePromise
                    .then(function() {
                        return req.api.restoreSemiAutoShortCommit(res.formData);
                    })
                    .then(
                        function(result) {
                            if (result.body) {
                                if (result.body.state) {
                                    return when.reject(result.body.state);
                                }

                                if (result.body.status && result.body.status === 'ok') {
                                    return when.reject('nextroute');
                                }
                            }
                        },
                        function(error) {
                            if (error) {
                                [].concat(error).forEach(function(code) {
                                    helper.activateFieldError(code, form);
                                });
                            }

                            return constructor.errorProcess(error, res);
                        }
                    );
            }

            // validate and compile form
            compilePromise = compilePromise
                .then(function() {
                    return form.validate(req.body);
                })
                .then(function() {
                    return form.compile(res.locals.language);
                })
                .then(function(compiled) {
                    res.locals.form = {
                        control: compiled
                    };
                })
                .catch(function(state) {
                    if (state && state === 'nextroute') {
                        return state;
                    }

                    res.locals.errorState = '';
                    var messages = [];

                    [].concat(helper.stateMessage[state]).forEach(function(err) {
                        messages.push(locErr[err]);
                    });
                    res.locals.errorState = messages.join(' ');
                })
                .done(function(state) {
                    if (state && state === 'nextroute') {
                        return next('route');
                    }

                    res.render(`restore.fio.${res.locals.language}.js`);
                });
        },

        changepass(req, res) {
            res.locals.formAction = res.locals.isPdd
                ? `/for/${res.locals.pddDomain}/restoration/semi_auto_pass/submitpassword`
                : '/restoration/semi_auto_pass/submitpassword';

            const controller = req._controller;
            var form = constructor.getForm[res.locals.isPdd ? 'changepassPdd' : 'changepass']().setApi(req.api);
            // eslint-disable-next-line no-unused-vars
            var compilePromise = when.resolve();

            if (res.locals.state === 'submitpassword') {
                compilePromise = compilePromise
                    // submit password
                    .then(function() {
                        return req.api.authChangePassword(req.body);
                    })
                    .then(
                        function(result) {
                            var body = result.body;

                            if (body.cookies) {
                                controller.augmentResponse(body);

                                if (body.is_replaced_phone_with_quarantine) {
                                    req.flash('info', {
                                        id: 'id1',
                                        data: {
                                            timeout: body.secure_phone_pending_until
                                        }
                                    });
                                }

                                if (body.is_conflicted_operation_exists || body.is_yasms_errors_when_replacing_phone) {
                                    req.flash('info', {id: 'id2'});
                                }

                                if (body.enable_2fa_track_id) {
                                    req.flash('enable_2fa_track_id', {id: body.enable_2fa_track_id});
                                }

                                return res.redirect(
                                    url.format({
                                        protocol: req.headers['x-real-scheme'],
                                        hostname: req.hostname,
                                        pathname: '/auth/finish',
                                        query: {
                                            track_id: req.body['track_id'] || res.locals.track_id
                                        }
                                    })
                                );
                            }
                        },
                        function(error) {
                            if (error) {
                                [].concat(error).forEach(function(code) {
                                    helper.activateFieldError(code, form);
                                });
                            }

                            return constructor.errorProcess(error, res);
                        }
                    );
            }

            if (res.locals.state === 'finishpassword') {
                var session = res.locals.isPdd ? req.cookies['Eda_id'] : req.cookies['Session_id'];

                compilePromise = compilePromise
                    .then(function() {
                        return req.api.sessionCheck({
                            session,
                            track_id: (req.nquery && req.nquery.track_id) || req.query.track_id
                        });
                    })
                    .then(
                        function(result) {
                            var body = result.body;

                            if (body && body.session_is_correct) {
                                var mdaCookie = req.cookies['mda'];
                                var needMDA = false;
                                var retpath = body.retpath;
                                var fretpath = body.fretpath;
                                var clean = body.clean;
                                var mdaQuery;
                                var exitURL;

                                if (mdaCookie === '1') {
                                    needMDA = true;
                                } else if (mdaCookie === '0') {
                                    needMDA = false;
                                } else if (/.*(.yandex\.ru.*)/.test(req.hostname)) {
                                    needMDA = true;
                                }

                                if (!retpath) {
                                    retpath = url.format({
                                        protocol: req.headers['x-real-scheme'],
                                        hostname: req.hostname,
                                        pathname: '/passport',
                                        query: {
                                            mode: 'passport'
                                        }
                                    });
                                }

                                mdaQuery = {
                                    retpath,
                                    ncrnd: String(Math.round(Math.random() * 1000000))
                                };

                                if (fretpath) {
                                    mdaQuery['fretpath'] = fretpath;
                                }

                                if (clean) {
                                    mdaQuery['clean'] = clean;
                                }

                                if (needMDA) {
                                    exitURL = url.format({
                                        protocol: req.headers['x-real-scheme'],
                                        hostname: config.paths.mda,
                                        pathname: 'login',
                                        query: mdaQuery
                                    });
                                } else {
                                    exitURL = retpath;
                                }

                                req.api.delTrack();
                                return res.redirect(exitURL);
                            }
                        },
                        function(error) {
                            if (error) {
                                [].concat(error).forEach(function(code) {
                                    helper.activateFieldError(code, form);
                                });
                            }

                            return constructor.errorProcess(error, res);
                        }
                    );
            }

            // validate and compile form
            compilePromise = compilePromise
                .then(function() {
                    return form.validate(req.body);
                })
                .then(function() {
                    var number = req.body['phone_number'] || req.query['phone_number'];
                    var phone = form.getField('phone_number');

                    if (phone && number) {
                        phone.setValue(number).setOptions({
                            hasConfirmedPhone: true,
                            state: 'confirmed'
                        });
                    }

                    return form.compile(res.locals.language);
                })
                .then(function(compiled) {
                    res.locals.form = {
                        control: compiled
                    };
                })
                .catch(function(state) {
                    helper.parseState(res, state);
                })
                .then(function() {
                    res.render(`restore.changepassword.${res.locals.language}.js`);
                });
        }
    },

    errorProcess(err, res) {
        var locErr = helper.getErrorsTexts(res.locals.language);
        var locMend = helper.getMendTexts(res.locals.language);

        res.locals.errors = [];

        function getErrorMessage(code) {
            var errId = code;

            if (helper.skipErrIds.indexOf(code) !== -1) {
                return;
            }

            if (helper.internalErrIds.indexOf(code) !== -1) {
                errId = 'internal';
            }

            if (!helper.errorIds[errId]) {
                errId = 'internal';
            }

            var error = {
                code
            };

            var errorResult = [];

            [].concat(helper.errorIds[errId]).forEach(function(id) {
                errorResult.push(locErr[id]);
            });

            error.msg = errorResult.join(' ');

            if (helper.mendIds[errId]) {
                var mendResult = [];

                [].concat(helper.mendIds[errId]).forEach(function(id) {
                    mendResult.push(locMend[id]);
                });

                error.mend = mendResult.join(' ');
            }

            res.locals.errors.push(error);
        }

        [].concat(err).forEach(function(code) {
            getErrorMessage(code);
        });

        return err;
    },

    viewProcess(req, res, next) {
        var pageType = 'base';

        if (res.locals && res.locals.mode === 'access_to_change_password') {
            pageType = 'shortform';

            if (['entertpassword', 'submitpassword', 'finishpassword'].indexOf(res.locals.state) >= 0) {
                pageType = 'changepass';
            }
        }

        constructor.restoreProcess[pageType](req, res, next);
    }
};

exports.restore = {};
exports.restore.enter = [
    function(req, res, next) {
        res.locals.state = 'enter';
        next();
    },
    setup,
    constructor.viewProcess
];

exports.restore.submit = [
    createCSRFValidator(
        function(req, res, next) {
            res.locals.state = 'submit';

            return next();
        },
        function(req, res) {
            if (res.locals && res.locals.mode === 'access_to_change_password') {
                return res.redirect('/auth');
            }

            return res.redirect('/passport?mode=restore');
        }
    ),
    setup,
    helper.formatFieldsValues,
    constructor.viewProcess
];

exports.restore.finish = [
    setup,
    function(req, res, next) {
        res.locals.state = 'finish';

        next();
    },
    constructor.viewProcess
];

exports.restore.enterpassword = [
    createCSRFValidator(
        function(req, res, next) {
            res.locals.state = 'entertpassword';

            return next();
        },
        function(req, res) {
            return res.redirect('/auth');
        }
    ),
    setup,
    constructor.viewProcess
];

exports.restore.submitpassword = [
    createCSRFValidator(
        function(req, res, next) {
            res.locals.state = 'submitpassword';

            return next();
        },
        function(req, res) {
            return res.redirect('/auth');
        }
    ),
    setup,
    constructor.viewProcess
];

exports.restore.finishpassword = [
    setup,
    function(req, res, next) {
        res.locals.state = 'finishpassword';

        next();
    },
    constructor.viewProcess
];
