// semiauto version 3

var _ = require('lodash');
var url = require('url');
var when = require('when');
var locs = require('../loc/auth.json');
var PLog = require('plog');
var PForm = require('pform');
var apiSetup = require('./common/apiSetup');
var restoreSettings = require('./restore.base').settings;
var socialSetup = require('./common/socialSetup');
var createCSRFValidator = require('./common/createCSRFValidator');
const getYaExperimentsFlags = require('./common/getYaExperimentsFlags');

var FieldRealReason = require('../blocks/control/restore/real-reason/real-reason.field');
var FieldFeedbackEmail = require('../blocks/control/restore/feedback-email/feedback-email.field');
var FieldFirstname = require('../blocks/control/firstname/firstname.field');
var FieldLastname = require('../blocks/control/lastname/lastname.field');
var FieldBirthday = require('../blocks/control/birthday/birthday.field');
var FieldLastPasswords = require('../blocks/control/restore/last-passwords/last-passwords.field');
var FieldLastAuth = require('../blocks/control/restore/last-auth/last-auth.field');
var FieldEulaConfidential = require('../blocks/control/checkbox/eula-confidential/eula-confidential.field.js');
var FieldSubmit = require('../blocks/control/submit/submit.field');
var FieldPhones = require('../blocks/control/restore/phones/phones.field');
var FieldAdditionalEmail = require('../blocks/control/restore/additional-email/additional-email.field');
var FieldQuestions = require('../blocks/control/restore/questions/questions.field');
var FieldAnswers = require('../blocks/control/restore/answers/answers.field');
var FieldRegistrationDate = require('../blocks/control/restore/registration-date/registration-date.field');
var FieldRegistrationCountry = require('../blocks/control/restore/registration-country/registration-country.field');
var FieldRegistrationCity = require('../blocks/control/restore/registration-city/registration-city.field');
var FieldSocialProfiles = require('../blocks/control/restore/social-profiles/social-profiles.field');
var FieldServices = require('../blocks/control/restore/services/services.field');
var FieldAddress = require('../blocks/control/restore/address/address.field');
var FieldCountry = require('../blocks/control/restore/address/country/country.field');
var FieldCity = require('../blocks/control/restore/address/city/city.field');
var FieldStreet = require('../blocks/control/restore/address/street/street.field');
var FieldBuilding = require('../blocks/control/restore/address/building/building.field');
var FieldSuite = require('../blocks/control/restore/address/suite/suite.field');
var FieldFoldersMail = require('../blocks/control/restore/mail/folders-mail/folders-mail.field');
var FieldSenderMail = require('../blocks/control/restore/mail/sender-mail/sender-mail.field');
var FieldCollectorMail = require('../blocks/control/restore/mail/collector-mail/collector-mail.field');
var FieldWhitelistMail = require('../blocks/control/restore/mail/whitelist-mail/whitelist-mail.field');
var FieldBlacklistMail = require('../blocks/control/restore/mail/blacklist-mail/blacklist-mail.field');
var FieldContactReason = require('../blocks/control/restore/contact-reason/contact-reason.field');
var FieldUserEnabled = require('../blocks/control/restore/user-enabled/user-enabled.field');
var FieldAttach = require('../blocks/control/restore/attach/attach.field');

exports.route = function(app) {
    var pathname = '/restoration/semi_auto';

    app.all(pathname, this.restore.enter)
        .get(`${pathname}/commit`, this.restore.enter)
        .post(`${pathname}/commit`, this.restore.submit)
        .post(`${pathname}/commit`, this.restore.enter);
};

var setup = [
    function(req, res, next) {
        var controller = req._controller;

        res.locals.track_id = (req.nquery && req.nquery['track_id']) || (req.body && req.body['track_id']);
        res.locals.process_uuid = req.query.process_uuid || (req.body && req.body.process_uuid);

        if (!res.locals.track_id) {
            // без трека отправляем на mode=passport
            return res.redirect(url.format(controller.getModePassportUrl()));
        }

        controller
            .getLanguage()
            .then(function(lang) {
                res.locals.language = lang;
            })
            .catch(function(err) {
                res.locals.language = 'ru';

                PLog.warn()
                    .logId(req.logID)
                    .type('semiauto')
                    .write(err);
            })
            .done(function() {
                return next();
            });
    },
    apiSetup,
    getYaExperimentsFlags,
    socialSetup
];

function getState(req, res, next) {
    req.api.restoreSemiAutoGetState({track_id: res.locals.track_id}).then(
        function(data) {
            if (data.body && data.body.state) {
                return next([data.body.state]);
            }

            if (!data.body || !data.body.track_state) {
                return next(['nostate']);
            }

            _.assign(res.locals, {
                state: data.body.track_state,
                login: data.body.user_entered_login,
                questions: data.body.questions,
                isChangeHint: data.body['request_source'] && data.body['request_source'] === 'changehint'
            });

            next();
        },
        function(err) {
            if (err[0] === 'track.not_found') {
                var controller = req._controller;

                return res.redirect(url.format(controller.getModePassportUrl()));
            }

            next(err);
        }
    );
}

var getForm = {
    personal_data: function() {
        return new PForm(
            new FieldRealReason().setRequired(),
            new FieldFeedbackEmail()
                .setRequired()
                .setHint('%semiauto.feedback-note')
                .setLabel('%semiauto.feedbackemail'),
            new FieldFirstname()
                .setRequired()
                .setHint('%semiauto.name-note')
                .setLabel('%semiauto.name')
                .setOptions({multiplyFields: true, maxFieldsCount: 2}),
            new FieldLastname()
                .setHint('%semiauto.lastname-note')
                .setRequired()
                .setOptions({multiplyFields: true, maxFieldsCount: 2}),
            new FieldBirthday().setRequired(),
            new FieldLastPasswords()
                .setRequired()
                .setHint('%semiauto.last-password-note')
                .setLabel('%semiauto.lastpassword')
                .setOptions({multiplyFields: true, maxFieldsCount: 3}),
            new FieldLastAuth().setRequired(),
            new FieldEulaConfidential().setRequired(),
            new FieldSubmit().setOption('theme', 'action').setLabel('%next')
        );
    },
    recovery_tools: function() {
        return new PForm(
            new FieldPhones()
                .setHint('%semiauto.phones-note')
                .setLabel('%semiauto.phones')
                .setOptions({multiplyFields: true, maxFieldsCount: 5}),
            new FieldAdditionalEmail()
                .setHint('%semiauto.additional-email-note')
                .setLabel('%semiauto.additional-email')
                .setOptions({multiplyFields: true, maxFieldsCount: 5}),
            new FieldQuestions(),
            new FieldAnswers(),
            new FieldSubmit()
                .setRequired()
                .setOption('theme', 'action')
                .setLabel('%next')
        );
    },

    registration_data: function() {
        return new PForm(
            new FieldRegistrationDate().setLabel('%semiauto.registration-date').setRequired(),
            new FieldRegistrationCountry().setRequired().setLabel('%semiauto.registration-country'),
            new FieldRegistrationCity().setLabel('%semiauto.registration-city'),
            new FieldSubmit().setOption('theme', 'action').setLabel('%next')
        );
    },
    used_services: function() {
        return new PForm(
            new FieldSocialProfiles().setHint('%semiauto.social-profiles-note').setOption('limit', 10),
            new FieldServices(),
            new FieldSubmit()
                .setRequired()
                .setOption('theme', 'action')
                .setLabel('%next')
        );
    },
    services_data: function() {
        return new PForm(
            new FieldAddress().setHint('%semiauto.address-note').setLabel('%semiauto.address'),
            new FieldCountry().setOption('grid', 'two'),
            new FieldCity().setOption('grid', 'two'),
            new FieldStreet().setOption('grid', 'two'),
            new FieldBuilding().setOption('grid', 'four'),
            new FieldSuite().setOption('grid', 'four'),

            new FieldFoldersMail()
                .setHint('%semiauto.folders-note')
                .setLabel('%semiauto.folders')
                .setOptions({multiplyFields: true, maxFieldsCount: 5}),
            new FieldSenderMail()
                .setHint('%semiauto.sender-note')
                .setLabel('%semiauto.sender')
                .setOptions({multiplyFields: true, maxFieldsCount: 5}),
            new FieldCollectorMail()
                .setHint('%semiauto.collector-note')
                .setLabel('%semiauto.collector')
                .setOptions({multiplyFields: true, maxFieldsCount: 5}),
            new FieldWhitelistMail()
                .setHint('%semiauto.whitelist-note')
                .setLabel('%semiauto.whitelist')
                .setOptions({multiplyFields: true, maxFieldsCount: 5}),
            new FieldBlacklistMail()
                .setHint('%semiauto.blacklist-note')
                .setLabel('%semiauto.blacklist')
                .setOptions({multiplyFields: true, maxFieldsCount: 5}),
            new FieldSubmit()
                .setRequired()
                .setOption('theme', 'action')
                .setLabel('%next')
        );
    },
    final_info: function() {
        return new PForm(
            new FieldContactReason().setLabel('%semiauto.contact-reason'),
            new FieldUserEnabled().setLabel('%semiauto.user-enabled'),
            new FieldAttach().setLabel('%semiauto.attach'),
            new FieldSubmit()
                .setRequired()
                .setOption('theme', 'action')
                .setLabel('%semiauto.send')
        );
    },
    final_info_changehint: function() {
        return new PForm(
            new FieldContactReason().setLabel('%semiauto.contact-reason'),
            new FieldAttach().setLabel('%semiauto.attach'),
            new FieldSubmit()
                .setRequired()
                .setOption('theme', 'action')
                .setLabel('%semiauto.send')
        );
    }
};

function normalizeDate(data, prefix) {
    var year = data[`${prefix}year`] || '0000';
    var month = data[`${prefix}month`] === 13 ? '00' : data[`${prefix}month`] || '00';
    var day = data[`${prefix}day`] || '00';
    var date;

    if ((year || day) && month !== 13) {
        date = [year, month, day.trim().length === 1 && day < 10 ? `0${day.trim()}` : day].join('-');
    }

    return date;
}

var internalErrIds = ['exception.unhandled', 'track.invalid_state', 'track.not_found'];

var skipErrIds = [
    'birthday.invalid',
    'birthday.empty',
    'firstnames.empty',
    'lastnames.empty',
    'passwords.empty',
    'password_auth_date.empty',
    'password_auth_date.invalid',
    'eula_accepted.not_accepted',
    'registration_city.empty',
    'registration_country.empty',
    'registration_date.invalid',
    'registration_date.empty',
    'eula_accepted.empty',
    'contact_email.empty',
    'contact_email.invalid',
    'contact_email.from_same_account',
    'social_accounts.invalid',
    'email_blacklist.invalid',
    'email_blacklist.empty',
    'email_blacklist.duplicate',
    'email_folders.invalid',
    'email_folders.empty',
    'email_folders.duplicate',
    'email_whitelist.invalid',
    'email_whitelist.empty',
    'email_whitelist.duplicate',
    'outbound_emails.invalid',
    'outbound_emails.duplicate',
    'outbound_emails.empty',
    'email_collectors.empty',
    'email_collectors.invalid',
    'email_collectors.duplicate',
    'question.empty',
    'photo_file.file_too_large',
    'phone_numbers.empty',
    'phone_numbers.invalid',
    'phone_numbers.duplicate',
    'emails.empty',
    'emails.invalid',
    'emails.duplicate',
    'delivery_addresses.city.empty',
    'delivery_addresses.city.invalid',
    'delivery_addresses.country.empty',
    'delivery_addresses.country.invalid',
    'delivery_addresses.street.empty',
    'delivery_addresses.street.invalid',
    'delivery_addresses.building.empty',
    'delivery_addresses.building.invalid',
    'question_answer.answer.long',
    'question_answer.answer.empty',
    'question_answer.answer.invalid',
    'question_answer.question.long',
    'question_answer.question.empty',
    'question_answer.question.invalid',
    'services.invalid'
];

var stateMessage = {
    'account.disabled': ['ErrorsTexts.badlog_blocked', 'disabled'],
    'account.not_found': ['ErrorsTexts.deleted', 'deleted'],
    'account.disabled_on_deletion': ['ErrorsTexts.deleted', 'deleted'],
    'account.without_password': 'without_password',
    'backend.historydb_api_failed': ['ErrorsTexts.internal', 'crap'],
    'backend.historydb_api_permanent_error': ['ErrorsTexts.internal', 'crap'],
    'backend.oauth_failed': ['ErrorsTexts.internal', 'crap'],
    'compare.not_matched': ['import.account_not_found', 'account_not_found'],
    password_change_forbidden: 'pdd_password_change_forbidden',
    complete_social: 'social_without_password',
    complete_pdd: 'request_pdd_admin',
    rate_limit_exceeded: 'restore_fio_limit_exceeded',
    complete_autoregistered: 'restore_complete_autoregistered',
    domain_not_served: 'restore_domain_not_served',
    'action.not_required': ['semiauto.error.action-notrequired-title', 'semiauto.error.action-notrequired-note'],
    process_restart_required: ['semiauto.error.restart-process-title', 'semiauto.error.restart-process-note'],
    internal: ['semiauto.error.restart-process-title', 'semiauto.error.restart-process-note']
};

var needsRestart = ['internal', 'process_restart_required', 'action.not_required'];

const fatalErrors = ['backend.historydb_api_failed', 'backend.oauth_failed'];

var fieldsMapping = {
    firstname: 'firstnames',
    lastname: 'lastnames',
    'feedback-email': 'contact_email',
    'registration-country': 'registration_country',
    'registration-country_id': 'registration_country_id',
    'registration-city': 'registration_city',
    'registration-city_id': 'registration_city_id',
    'contact-reason': 'contact_reason',
    eula_accepted_confidential: 'eula_accepted',
    'user-enabled': 'user_enabled',
    'folders-mail': 'email_folders',
    'sender-mail': 'outbound_emails',
    'collector-mail': 'email_collectors',
    'whitelist-mail': 'email_whitelist',
    'blacklist-mail': 'email_blacklist',
    questions_id: 'question_id',
    questions: 'question',
    answers: 'answer',
    'last-passwords': 'passwords',
    'last-auth': 'password_auth_date',
    phones: 'phone_numbers',
    'additional-email': 'emails',
    task_id: 'social_accounts'
};

var fieldsNameMap = {};

Object.keys(fieldsMapping).forEach(function(key) {
    fieldsNameMap[fieldsMapping[key]] = key;
});

fieldsNameMap['city'] = 'delivery_addresses.city';
fieldsNameMap['country'] = 'delivery_addresses.country';
fieldsNameMap['street'] = 'delivery_addresses.street';
fieldsNameMap['building'] = 'delivery_addresses.building';
fieldsNameMap['suite'] = 'delivery_addresses.suite';

var fieldsToArray = [
    'firstnames',
    'lastnames',
    'passwords',
    'services',
    'social_accounts',
    'email_folders',
    'outbound_emails',
    'email_collectors',
    'email_whitelist',
    'email_blacklist',
    'phone_numbers',
    'emails'
];

var fieldsToBool = ['eula_accepted', 'user_enabled'];

var fieldsToBoolInvert = ['user_enabled'];

var disabledButRequired = ['user_enabled'];

var fieldsToNumber = ['registration_country_id', 'registration_city_id'];

var requiredAddrFields = ['country', 'city', 'street', 'building'];

var addrFields = ['suite'];

var parseBody = [
    function parse(req, res, next) {
        var body = req.body;

        req.parsedBody = {};

        Object.keys(body).forEach(function(key) {
            var keyName = fieldsMapping[key] || key;

            if (body[key]) {
                req.parsedBody[keyName] = body[key];
            }
        });

        req.parsedBody.birthday = normalizeDate(body, 'b');
        req.parsedBody.password_auth_date = normalizeDate(body, 'last-auth_');
        req.parsedBody.registration_date = normalizeDate(body, 'r');

        next();
    },
    function clean(req, res, next) {
        [
            'track_id',
            'bday',
            'bmonth',
            'byear',
            'rday',
            'rmonth',
            'ryear',
            'last-auth_day',
            'last-auth_month',
            'last-auth_year',
            'csrf_token',
            'state'
        ].forEach(function(key) {
            delete req.parsedBody[key];
        });

        ['birthday', 'password_auth_date', 'registration_date'].forEach(function(key) {
            if (req.parsedBody[key] === '0000-00-00') {
                delete req.parsedBody[key];
            }
        });

        next();
    },
    function disabledFields(req, res, next) {
        disabledButRequired.forEach(function(key) {
            if (req.parsedBody[key] === undefined) {
                req.parsedBody[key] = false;
            }
        });

        next();
    },
    function toNumber(req, res, next) {
        fieldsToNumber.forEach(function(key) {
            if (req.parsedBody[key]) {
                req.parsedBody[key] = parseInt(req.parsedBody[key], 10);
            } else {
                delete req.parsedBody[key];
            }
        });

        next();
    },
    function toBoolean(req, res, next) {
        fieldsToBool.forEach(function(key) {
            if (req.parsedBody[key] !== undefined) {
                req.parsedBody[key] = req.parsedBody[key] === 'on';
            }
        });

        next();
    },
    function invertBoolean(req, res, next) {
        fieldsToBoolInvert.forEach(function(key) {
            if (req.parsedBody[key] !== undefined) {
                req.parsedBody[key] = !req.parsedBody[key];
            }
        });

        next();
    },
    function toArray(req, res, next) {
        fieldsToArray.forEach(function(key) {
            if (!req.parsedBody[key]) {
                delete req.parsedBody[key];
            }

            if (typeof req.parsedBody[key] === 'string' && req.parsedBody[key]) {
                req.parsedBody[key] = [req.parsedBody[key]];
            }

            if (Array.isArray(req.parsedBody[key])) {
                var valuesArr = req.parsedBody[key];

                req.parsedBody[key] = [];

                valuesArr.forEach(function(val) {
                    if (val && val.length) {
                        req.parsedBody[key].push(val);
                    }
                });
            }
        });

        next();
    },
    function formatAddress(req, res, next) {
        var addr = {};

        requiredAddrFields.concat(addrFields).forEach(function(key) {
            if (req.body[key]) {
                addr[key] = req.body[key];
            }

            delete req.parsedBody[key];
        });

        if (!Object.keys(addr).length || Object.keys(addr).length === 1) {
            return next();
        }

        req.parsedBody['delivery_addresses'] = [addr];

        next();
    },
    function formatQuestions(req, res, next) {
        if (req.parsedBody.question && req.parsedBody.question.trim() !== '') {
            req.parsedBody.question_answer = {};

            ['question', 'question_id', 'answer'].forEach(function(key) {
                req.parsedBody.question_answer[key] =
                    key === 'question_id' ? Number(req.parsedBody[key]) : req.parsedBody[key];
                delete req.parsedBody[key];
            });
        }

        next();
    },
    function parseAttach(req, res, next) {
        var files = req.files || {};
        var file = files[Object.keys(files)[0]];

        if (file && file.size) {
            req.parsedBody.attach = file;
        }

        next();
    }
];

function errorProcess(errors, req, res, next) {
    if (!errors || !errors.length) {
        return next();
    }

    var locErr = locs[res.locals.language]['Errors'];
    var locMend = locs[res.locals.language]['Mend'];

    req.formErrors = errors;
    res.locals.errors = [];

    function getErrorMessage(code) {
        var errId = code;
        var error = {};

        if (skipErrIds.indexOf(code) !== -1) {
            return;
        }

        if (internalErrIds.indexOf(code) !== -1) {
            errId = 'internal';
        }

        if (stateMessage[errId] === undefined) {
            errId = 'internal';
        }

        if (errId === 'internal') {
            res.status(500);
        }

        if (Array.isArray(stateMessage[errId])) {
            var state = _.clone(stateMessage[errId]);
            var titleCode = state.shift();
            var message = [];

            [].concat(state).forEach(function(stateCode) {
                message.push(locErr[stateCode] || locMend[stateCode]);
            });

            error.title = locErr[titleCode] || locMend[titleCode];
            error.message = message.join(' ');
        } else {
            error.message = locErr[stateMessage[errId]] || locMend[stateMessage[errId]];
        }

        if (needsRestart.indexOf(errId) !== -1) {
            error.needsRestart = true;
        }

        error.code = errId;
        error.isChangeHint = req.body.type === 'changehint';

        res.locals.errorState = true;
        res.locals.errors.push(error);
    }

    [].concat(errors).forEach(function(code) {
        getErrorMessage(code);
    });

    next();
}

function activateFieldError(code, form) {
    if (typeof code !== 'string') {
        return;
    }

    var splitedCode = code.split('.');

    if (splitedCode.length === 3) {
        splitedCode.shift();
    }

    var fieldName = fieldsNameMap[splitedCode[0]] || splitedCode[0];
    var field = form.getField(fieldName);

    if (field) {
        if (splitedCode[1] === 'empty') {
            splitedCode[1] = 'missingvalue';
        }

        var err = field.getErrorByCode(splitedCode[1]);

        if (err) {
            err.setActive();
        }
    }
}

exports.restore = {};
exports.restore.enter = [
    errorProcess,
    setup,
    getState,
    errorProcess,
    apiSetup,
    function(req, res, next) {
        var form;

        const experimentFlags = res.locals.experiments && res.locals.experiments.flagsString;
        const experimentBoxes = res.locals.experiments && res.locals.experiments.boxes;

        req.api.statboxLogger({
            action: 'opened',
            mode: `restore_semi_auto_${res.locals.state || ''}${res.locals.isChangeHint ? '_changehint' : ''}`,
            track_id: res.locals.track_id || null,
            process_uuid: res.locals.process_uuid || null,
            ip: req.headers['x-real-ip'],
            host: req.hostname,
            user_agent: req.headers['user-agent'],
            yandexuid: req.cookies.yandexuid,
            experiment_flags: experimentFlags,
            experiment_boxes: experimentBoxes
        });

        if (res.locals.state === 'finished') {
            req.api.delTrack();
            return next();
        }

        if (res.locals.state && getForm[res.locals.state] !== undefined) {
            if (res.locals.state === 'final_info' && res.locals.isChangeHint) {
                res.locals.state = 'final_info_changehint';
            }

            form = getForm[res.locals.state]();
        } else {
            form = getForm['personal_data']();
        }

        form.setApi(req.api);

        if (res.locals.state === 'recovery_tools' && res.locals.questions.length) {
            res.locals.questions.unshift({
                id: -1,
                text: locs[res.locals.language]['common'].empty
            });

            form.getField('questions').setQuestions(res.locals.questions);
        }

        if (res.locals.state === 'personal_data' && res.locals.isChangeHint) {
            form.getField('eula_accepted_confidential').setLabel('%restoration.eula.label.changehint');
        }

        if (res.locals.state === 'used_services') {
            form.getField('services').setServices([
                {id: 'mail', label: '%semiauto.service.mail'},
                {id: 'disk', label: '%semiauto.service.disk'},
                {id: 'market', label: '%semiauto.service.market'},
                {id: 'metrika', label: '%semiauto.service.metrika'},
                {id: 'yandsearch', label: '%semiauto.service.search'},
                {id: 'music', label: '%semiauto.service.music'}
            ]);

            form.getField('social-profiles').setProviders((res.locals.social && res.locals.social.providers) || {});
        }

        if (req.formErrors && req.formErrors.length) {
            [].concat(req.formErrors).forEach(function(code) {
                activateFieldError(code, form);
            });
        }

        when.resolve()
            .then(function() {
                return form.validate(req.body);
            })
            .then(function() {
                return form.compile(res.locals.language);
            })
            .then(function(data) {
                res.locals.form = {
                    control: data
                };

                return next();
            });
    },
    function(req, res) {
        res.render(`restore.semiauto.${res.locals.language}.js`);
    }
];

exports.restore.submit = [
    createCSRFValidator(
        function(req, res, next) {
            return next();
        },
        function(req, res) {
            return res.redirect('/restoration/form');
        }
    ),
    setup,
    apiSetup,
    parseBody,
    function(req, res, next) {
        var controller = req._controller;

        req.api
            .restoreSemiAutoCommit({
                body: req.parsedBody,
                version: 4
            })
            .then(function(data) {
                var processUUID = res.locals.process_uuid;
                var query = {
                    track_id: req.body && req.body['track_id']
                };

                if (processUUID) {
                    query.process_uuid = processUUID;
                }

                if (data.body.state) {
                    if (data.body.state === 'restoration_passed') {
                        return res.redirect(
                            url.format(
                                _.extend(controller.getUrl(), {
                                    pathname: (restoreSettings.paths && restoreSettings.paths.changepassword) || '',
                                    query: query,
                                    search: null
                                })
                            )
                        );
                    }

                    return next([data.body.state]);
                }

                return res.redirect(
                    url.format(
                        _.extend(controller.getUrl(), {
                            query: query,
                            search: null
                        })
                    )
                );
            })
            .catch(function(errors) {
                if (Array.isArray(errors) && fatalErrors.indexOf(errors[0]) !== -1) {
                    var processUUID = res.locals.process_uuid;
                    var currentUrl = controller.getUrl();
                    var query = {};

                    if (processUUID) {
                        query.process_uuid = processUUID;
                    }

                    query.reason_to_repeat = errors[0];

                    PLog.warn()
                        .logId(req.logID)
                        .type('semiauto.submit')
                        .write(errors);

                    return res.redirect(
                        url.format(
                            Object.assign({}, currentUrl, {
                                pathname: '/restoration/form',
                                query: query,
                                search: null
                            })
                        )
                    );
                }

                PLog.info()
                    .logId(req.logID)
                    .type('semiauto.submit')
                    .write(errors);

                return next(errors);
            });
    },
    errorProcess
];
