var config = require('../configs/current');
var paths = config.paths;
var apiSetup = require('./common/apiSetup');
var url = require('url');
var yakeyUrls = require('../lib/yakey-urls');

exports.routes = {};

exports.route = function(app) {
    var routes = this.routes;

    app.get('/redirect/?', routes.validate);
    app.get('/redirect/2fa/?', routes.twofa);
    app.get(
        '/passport/?',
        function(req, res, next) {
            if (req.nquery && req.nquery.mode === 'tauth') {
                next();
            } else {
                next('route');
            }
        },
        routes.validate
    );
};

var setDefaultRetpath = function(req, res, next) {
    var retpath = url.parse(paths.retpath);

    retpath.protocol = req.headers['x-real-scheme'];
    retpath.hostname = req.hostname;

    res.defaultRetpath = url.format(retpath);
    next();
};

exports.routes.social = [
    setDefaultRetpath,
    function(req, res, next) {
        var retpath = res.defaultRetpath;
        var input = req.body['retpath'] || (req.nquery && req.nquery['retpath']);

        if (input) {
            retpath = url.format({
                protocol: req.headers['x-real-scheme'],
                hostname: req.hostname,
                pathname: '/redirect',
                query: {
                    url: input
                }
            });
        }

        if (config.multiauth && res.locals.accounts && !input) {
            return next();
        }

        res.locals.finishRetpath = retpath;
        next();
    }
];

exports.routes.validate = [
    setDefaultRetpath,
    function(req, res, next) {
        req.retpath_url = req.nquery && (req.nquery.url || req.nquery.retpath);
        if (!req.retpath_url) {
            res.redirect(res.defaultRetpath);
        } else {
            next();
        }
    },
    apiSetup,
    function(req, res, next) {
        req.api.validateRetpath({retpath: req.retpath_url}).then(
            function(results) {
                if (results.body && results.body.retpath) {
                    res.redirect(results.body.retpath);
                } else {
                    next();
                }
            },
            function() {
                next();
            }
        );
    },
    function(req, res) {
        res.redirect(res.defaultRetpath);
    }
];

exports.routes.twofa = [
    function(req, res, next) {
        var controller = req._controller;

        controller
            .getLanguage()
            .then(function(lang) {
                res.locals.language = lang;
            })
            .catch(function(err) {
                res.locals.language = 'ru';

                require('plog')
                    .warn()
                    .logId(req.logID)
                    .type('redirect twofa languageDetect')
                    .write(err);
            })
            .done(function() {
                return next();
            });
    },
    function(req, res, next) {
        var lang = res.locals.language;
        var domain = req._controller.getTld();
        var urls = yakeyUrls.getUrls({
            lang: lang,
            domain: domain,
            host: req.hostname
        });

        req._controller
            .getUatraits()
            .then(function(result) {
                var os = result.OSFamily;
                var isMobile = result.isMobile;

                if (os === 'Android') {
                    return res.redirect(urls.googUrl);
                } else if (os === 'iOS') {
                    return res.redirect(urls.applUrl);
                } else if (isMobile) {
                    return res.redirect(urls.promoUrl);
                } else {
                    return res.redirect(urls.profileAccessUrl);
                }
            })
            .catch(next);
    },
    // eslint-disable-next-line no-unused-vars
    function(err, req, res, next) {
        require('plog')
            .warn()
            .logId(req.logID)
            .type('redirect twofa')
            .write(err);

        return res.redirect('https://yandex.ru/promo/2fa');
    }
];
