module.exports = function createState(req, res, next) {
    const locals = res.locals || {};
    const store = locals.store;
    const fieldsToAdd = {
        domik: {
            errors: {},
            requestPassword: false,
            requestCaptcha: false,
            passwordNotMatched: false,
            captchaNotMatched: false,
            loading: false
        },
        captcha: {
            loading: false,
            loadingAudio: false,
            playing: false,
            type: 'text',
            key: null,
            imageUrl: null,
            introSound: null,
            captchaSound: null
        },
        dashboard: {
            plus: Object.assign(
                {},
                {
                    country: locals.country,
                    allowed: locals.showPlus,
                    enabled: false
                },
                store.header.defaultAccount.plus
            )
        },
        metrics: {
            header: 'Страница безопасности'
        },
        monitoring: {
            page: 'profile.security'
        },
        isLoading: false
    };

    locals.store = {...locals.store, ...fieldsToAdd};

    return next();
};
