const express = require('express');
const router = express.Router();
const apiSetup = require('../../common/apiSetup');
const writeStatbox = require('../../common/writeStatbox');

const {Validator} = require('express-json-validator-middleware');
const validator = new Validator({allErrors: true}); // Pass in options to the Ajv instance
const {validate} = validator;

const bodySchema = require('./body.schema.json');
const doRequest = require('./doRequest');

const postRoute = [
    validate({
        body: bodySchema
    }),
    apiSetup,
    writeStatbox({
        action: 'opened',
        mode: 'sessguard_set'
    }),
    (req, res, next) => {
        doRequest(req, res)
            .then(
                (apiResponse) =>
                    new Promise((resolve) => {
                        const {retpath} = apiResponse;

                        if (!retpath) {
                            throw new Error(['retpath was invalid']);
                        }

                        req._controller.augmentResponse(apiResponse);

                        resolve(retpath);
                    })
            )
            .then((url) => req._controller.redirect(url))
            .catch(next);
    },
    errorsHandler
];

// eslint-disable-next-line no-unused-vars
function errorsHandler(err, _req, res, _next) {
    if (err.name === 'JsonSchemaValidationError') {
        return res.status(400).json({
            status: 'error',
            code: 'query-param named "container" is required'
        });
    }

    return res.status(500).json({
        status: 'error',
        code: err.error
    });
}

router.post('/', postRoute);
module.exports.router = router;
