module.exports = (req) =>
    new Promise((resolve, reject) => {
        const {container} = req.query;

        req.api
            .bundleSessionSessGuardContainerUse({container})
            .then((apiResponse) => {
                const {retpath, status} = apiResponse;

                req._controller.augmentResponse(apiResponse);

                if (retpath) {
                    return resolve(apiResponse);
                }

                return reject({
                    status
                });
            })
            .catch((err) => {
                return reject({
                    status: 'error',
                    error: err
                });
            });
    });
