var apiSetup = require('./common/apiSetup');
var url = require('url');
var locs = require('../loc/auth.json');
var _ = require('lodash');
var config = require('../configs/current');
var PLog = require('plog');
const writeStatbox = require('./common/writeStatbox');

exports.routes = {};

exports.route = function(app) {
    var routes = this.routes;

    app.all('/auth/session/?', routes.session);
};

exports.routes.session = [
    apiSetup,
    writeStatbox({
        action: 'opened',
        mode: 'auth_session'
    }),
    doSessionRequest,
    function(err, req, res, next) {
        var controller = req._controller;

        controller
            .getLanguage()
            .then(function(lang) {
                res.locals.language = lang;
            })
            .catch(function(err) {
                res.locals.language = 'ru';

                PLog.warn()
                    .logId(req.logID)
                    .type('session')
                    .write(err);
            })
            .done(function() {
                return next(err);
            });
    },
    errorHandler
];

function doSessionRequest(req, res, next) {
    const controller = req._controller;
    const request = Object.assign({}, req.query, req.body);
    const {track_id, code_verifier, keep_track} = request;
    const data = {
        passErrors: true,
        track_id
    };

    if (code_verifier) {
        data.code_verifier = code_verifier;
    }

    if (!track_id) {
        return next(new Error());
    }

    req.api
        .authSubmit('/1/bundle/session/', data)
        .then(function(result) {
            var body = result.body;
            var pathname = 'auth/finish';
            const queryToPass = {
                track_id
            };

            if (typeof keep_track !== 'undefined') {
                queryToPass.keep_track = keep_track;
            }

            controller.augmentResponse(body);

            if (body.cookies) {
                return res.redirect(
                    url.format({
                        protocol: req.headers['x-real-scheme'],
                        hostname: req.hostname,
                        pathname,
                        query: queryToPass
                    })
                );
            } else {
                req.retpathUrl = body.retpath;
                next(body.errors);
            }
        })
        .catch(function(err) {
            res.locals.language = 'ru';

            PLog.warn()
                .logId(req.logID)
                .type('session')
                .write(err);

            return next(err);
        });
}

// eslint-disable-next-line no-unused-vars
function errorHandler(err, req, res, next) {
    var retpath = req.retpathUrl;
    var lang = res.locals.language;
    var loc = locs[lang];
    var auth = {
        protocol: req.headers['x-real-scheme'],
        hostname: req.hostname,
        pathname: 'auth',
        query: {}
    };
    var data;

    if (retpath) {
        auth.query.retpath = _.escape(retpath);
    }

    data = {
        title: loc['Errors']['session_error_title'],
        messages: [loc['Errors']['session_error_message'].replace('%url%', url.format(auth))]
    };

    return res.render(`auth.message.${lang}.js`, data);
}

function getConfig() {
    return config;
}

exports.getConfig = getConfig;
exports.doSessionRequest = doSessionRequest;
exports.errorHandler = errorHandler;
