var url = require('url');
var _ = require('lodash');
var apiSetup = require('./common/apiSetup');
var locs = require('../loc/auth.json');

var langSetup = function(req, res, next) {
    new (require('../lib/controller'))(req, res, req.logID)
        .getLanguage()
        .then(function(lang) {
            res.locals.language = lang;
        })
        .catch(function(err) {
            res.locals.language = 'ru';

            require('plog')
                .warn()
                .logId(req.logID)
                .type('simple domik')
                .write(err);
        })
        .done(function() {
            return next();
        });
};

exports.routes = {};

exports.route = function(app) {
    var routes = this.routes;

    app.get('/simple-auth', routes.main);
    app.post('/simple-auth', routes.auth);
};

exports.routes.main = [
    langSetup,
    function(req, res) {
        res.render(`simple-auth.${res.locals.language}.js`);
    }
];

exports.routes.auth = [
    apiSetup,
    langSetup,
    function(req, res, next) {
        var data = {
            login: req.body.login,
            password: req.body.passwd
        };
        const controller = req._controller;

        req.api.authSubmit('/1/bundle/auth/password/submit/', data).done(function(result) {
            var logger = new (require('plog'))(req.logID, 'passport', 'simple-auth', 'authSubmit');

            controller.augmentResponse(result.body);

            if (result.body.cookies) {
                res.redirect(
                    url.format({
                        protocol: req.headers['x-real-scheme'],
                        hostname: req.hostname,
                        pathname: '/auth/finish/',
                        query: {
                            track_id: result.body['track_id']
                        }
                    })
                );
            } else {
                logger.warn('No cookies provided, redirect to main /auth');
                res.redirect(
                    url.format({
                        protocol: req.headers['x-real-scheme'],
                        hostname: req.hostname,
                        pathname: '/auth/',
                        query: {
                            track_id: result.body['track_id']
                        }
                    })
                );
            }
        }, next);
    },
    // eslint-disable-next-line no-unused-vars
    function(error, req, res, next) {
        if (Array.isArray(error) && error[0] === 'captcha.required') {
            var track_id = req.api.track();

            res.redirect(
                url.format({
                    protocol: req.headers['x-real-scheme'],
                    hostname: req.hostname,
                    pathname: '/auth/',
                    query: {
                        track_id,
                        mode: 'add-user'
                    }
                })
            );
        } else {
            var errorText = processErrors(error, res.locals.language);

            res.locals.error = errorText.error_msg;
            res.locals.error_hint = errorText.error_hint;
            res.render(`simple-auth.${res.locals.language}.js`);
        }
    }
];

function processErrors(error, lang) {
    var loc = locs[lang || 'ru'];

    var errIds = {
        'password.not_matched': 'ErrorsTexts.badlog',
        'password.not_matched.2fa': 'ErrorsTexts.badlog_2fa',
        'password.empty': 'Common.nopasswd',
        'account.disabled': 'ErrorsTexts.badlog_blocked',
        'account.not_found': 'ErrorsTexts.deleted',
        'account.disabled_on_deletion': 'ErrorsTexts.deleted',
        'account.registration_limited': 'import.sms_limit_exceeded',
        internal: 'ErrorsTexts.internal',
        retry: 'ErrorsTexts.retry',
        'backend.blackbox_failed': 'ErrorsTexts.auth_try_again',
        'backend.yasms_failed': 'ErrorsTexts.auth_try_again',
        'backend.database_failed': 'ErrorsTexts.auth_try_again',
        'backend.redis_failed': 'ErrorsTexts.auth_try_again',
        'login.invalid_format': 'ErrorsTexts.nodomain',
        'domain.not_hosted': 'ErrorsTexts.domainnotfound',
        'user.not_verified': 'field_human-confirmation_errors_unconfirmed',
        'sessionid.overflow': 'ErrorsTexts.sessionidoverflow',
        'account.compromised': 'ErrorsTexts.account_compromised',
        'session.invalid': 'session_invalid'
    };

    var mendIds = {
        'password.not_matched': 'creg_misspasswd',
        'password.not_matched.2fa': 'creg_misspasswd_2fa',
        internal: 'crap',
        'account.disabled': 'disabled',
        'account.not_found': 'deleted',
        'account.disabled_on_deletion': 'deleted',
        'session.invalid': 'session_invalid_mend',
        'sessionid.overflow': 'MendTexts.sessionidoverflow'
    };

    var errorParsed = {
        error_msg: loc['Errors'][errIds['internal']],
        error_hint: loc['Mend'][mendIds['internal']]
    };

    _.forEach(errIds, function(val, key) {
        if (error[0] === key) {
            if (mendIds[key]) {
                errorParsed.error_hint = loc['Mend'][mendIds[key]];
            }
            errorParsed.error_msg = loc['Errors'][errIds[key]];
        }
    });

    return errorParsed;
}
