const apiSetup = require('../common/apiSetup');
const apiRequest = require('../authv2/apiRequest');
const PLog = require('plog');

module.exports = () => {
    return [
        apiSetup,
        (req, res, next) => {
            res.withCode = true;
            return next();
        },
        apiRequest('authPasswordSubmit'),
        function(req, res, next) {
            const {authPasswordSubmit} = res.locals.result;

            if (!authPasswordSubmit) {
                return next(['internal']);
            }

            return res.json({
                status: 'ok',
                trackId: authPasswordSubmit.track_id,
                csrf: authPasswordSubmit.csrf_token,
                code: authPasswordSubmit.user_code
            });
        },
        // eslint-disable-next-line no-unused-vars
        (errors, req, res, next) => {
            PLog.warn()
                .logId(req.logID)
                .type('startDeviceCodeAuth')
                .write(errors);

            res.json({
                status: 'error',
                errors
            });
            res.send();
        }
    ];
};
