const apiSetup = require('../common/apiSetup');
const apiRequest = require('../authv2/apiRequest');
const PLog = require('plog');

module.exports = () => {
    return [
        apiSetup,
        apiRequest('authPasswordSubmit'),
        function(req, res, next) {
            const {authPasswordSubmit} = res.locals.result;

            if (!authPasswordSubmit) {
                return next(['internal']);
            }

            return res.json({
                status: 'ok',
                trackId: authPasswordSubmit.track_id,
                csrf: authPasswordSubmit.csrf_token
            });
        },
        // eslint-disable-next-line no-unused-vars
        (errors, req, res, next) => {
            PLog.warn()
                .logId(req.logID)
                .type('startQrCodeAuth')
                .write(errors);

            res.json({
                status: 'error',
                errors
            });
            res.send();
        }
    ];
};
