const PLog = require('plog');

const smartTvGatewayMiddleware = require('@kinopoisk-int/smarttv-auth-gateway/middleware');
const {PassportApisNames} = require('@kinopoisk-int/smarttv-auth-gateway/apis');
const writeStatbox = require('../common/writeStatbox');
const getMetrics = require('../common/getMetrics');

module.exports = (app) => {
    return [
        (req, res, next) => {
            res.removeHeader('X-Frame-Options');
            next();
        },
        writeStatbox({
            action: 'opened',
            mode: 'smarttv_gateway'
        }),
        getMetrics({header: 'SmartTV GateWay'}),
        smartTvGatewayMiddleware(
            {
                apis: {
                    [PassportApisNames.authDeviceCodeStart]: '/auth/smarttv-gateway/startCodeAuth/',
                    [PassportApisNames.authQrCodeStart]: '/auth/smarttv-gateway/startQrAuth/',
                    [PassportApisNames.checkAuthStatus]: '/auth/new/magic/status/',
                    [PassportApisNames.authMagicCode]: '/auth/magic/code/'
                },
                isDebugOn: ['development', 'testing', 'rc'].includes(app.get('env'))
            },
            (req, res) => res.locals.nonce
        ),
        // eslint-disable-next-line no-unused-vars
        (error, req, res, next) => {
            PLog.warn()
                .logId(req.logID)
                .type('smarttv gateway error')
                .write(error);

            res.status(500);
            res.send();
        }
    ];
};
